/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.acl;

import java.util.stream.Stream;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.model.MailboxACL;

public class PositiveUserACLDiff {
    private final ACLDiff aclDiff;

    public PositiveUserACLDiff(ACLDiff aclDiff) {
        this.aclDiff = aclDiff;
    }

    public static PositiveUserACLDiff computeDiff(MailboxACL oldACL, MailboxACL newACL) {
        return new PositiveUserACLDiff(ACLDiff.computeDiff(oldACL, newACL));
    }

    public Stream<MailboxACL.Entry> addedEntries() {
        return this.aclDiff.addedEntries().filter(this::hasPositiveUserKey);
    }

    public Stream<MailboxACL.Entry> removedEntries() {
        return this.aclDiff.removedEntries().filter(this::hasPositiveUserKey);
    }

    public Stream<MailboxACL.Entry> changedEntries() {
        return this.aclDiff.changedEntries().filter(this::hasPositiveUserKey);
    }

    private boolean hasPositiveUserKey(MailboxACL.Entry entry) {
        return !((MailboxACL.EntryKey)entry.getKey()).isNegative() && ((MailboxACL.EntryKey)entry.getKey()).getNameType().equals((Object)MailboxACL.NameType.user);
    }
}

