/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.james.mailetcontainer.impl.ProcessorUtil;
import org.apache.james.mailetcontainer.lib.AbstractStateMailetProcessor;
import org.apache.james.mailetcontainer.lib.MailProcessingErrorHandlingConfiguration;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.apache.james.util.MDCBuilder;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.apache.mailet.base.MailetPipelineLogging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessorImpl.class);
    private final MetricFactory metricFactory;
    private final MailProcessingErrorHandlingConfiguration processingErrorHandlingConfiguration;
    private final List<AbstractStateMailetProcessor.MailetProcessorListener> listeners;
    private final Mailet mailet;

    public ProcessorImpl(MetricFactory metricFactory, Mailet mailet, MailProcessingErrorHandlingConfiguration processingErrorHandlingConfiguration, List<AbstractStateMailetProcessor.MailetProcessorListener> listeners) {
        this.metricFactory = metricFactory;
        this.processingErrorHandlingConfiguration = processingErrorHandlingConfiguration;
        this.listeners = listeners;
        this.mailet = mailet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Mail mail) throws Exception {
        long start = System.currentTimeMillis();
        TimeMetric timeMetric = this.metricFactory.timer(this.mailet.getClass().getSimpleName());
        Throwable ex = null;
        String smtpSessionID = mail.getAttribute(Mail.SMTP_SESSION_ID).map(Attribute::getValue).map(AttributeValue::value).map(String.class::cast).orElse(null);
        try (Closeable closeable = MDCBuilder.create().addToContext("protocol", "MAILET").addToContext("action", "MAILET").addToContext("host", mail.getRemoteHost()).addToContext("sessionId", smtpSessionID).addToContext("state", mail.getState()).addToContext("mailet", this.mailet.getClass().getSimpleName()).addToContext("mail", mail.getName()).addToContext("recipients", ImmutableList.copyOf((Collection)mail.getRecipients()).toString()).addToContext("sender", mail.getMaybeSender().asString()).build();){
            MailetPipelineLogging.logBeginOfMailetProcess((Mailet)this.mailet, (Mail)mail);
            this.mailet.service(mail);
        }
        catch (Throwable me) {
            ex = me;
            String onMailetException = this.processingErrorHandlingConfiguration.onMailetException().map(value -> value.trim().toLowerCase(Locale.US)).orElse("error");
            if (onMailetException.equalsIgnoreCase("ignore")) {
                LOGGER.warn("Encountered error while executing mailet {}. Ignoring it.", (Object)this.mailet, (Object)ex);
                ProcessorUtil.verifyMailAddresses(mail.getRecipients());
            }
            if (onMailetException.equalsIgnoreCase("propagate")) {
                throw me;
            }
            ProcessorUtil.handleException(me, mail, this.mailet.getName(), onMailetException, LOGGER);
        }
        finally {
            timeMetric.stopAndPublish();
            MailetPipelineLogging.logEndOfMailetProcess((Mailet)this.mailet, (Mail)mail);
            long complete = System.currentTimeMillis() - start;
            if (mail.getRecipients().isEmpty()) {
                mail.setState("ghost");
            }
            for (AbstractStateMailetProcessor.MailetProcessorListener listener : this.listeners) {
                listener.afterMailet(this.mailet, mail.getName(), mail.getState(), complete, ex);
            }
        }
    }

    public String mailetName() {
        return this.mailet.getMailetInfo();
    }
}

