/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ValuePatternComponent;
import java.text.DecimalFormat;
import java.util.Random;

final class RandomValuePatternComponent
extends ValuePatternComponent {
    private static final long serialVersionUID = -670528378158953667L;
    private final long lowerBound;
    private final long span;
    @NotNull
    private final Random seedRandom;
    @Nullable
    private final String formatString;
    @NotNull
    private final ThreadLocal<DecimalFormat> decimalFormat;
    @NotNull
    private final ThreadLocal<Random> random;

    RandomValuePatternComponent(long lowerBound, long upperBound, long seed, @Nullable String formatString) {
        if (lowerBound == upperBound) {
            this.lowerBound = lowerBound;
            this.span = 1L;
        } else if (lowerBound > upperBound) {
            this.lowerBound = upperBound;
            this.span = lowerBound - upperBound + 1L;
        } else {
            this.lowerBound = lowerBound;
            this.span = upperBound - lowerBound + 1L;
        }
        this.seedRandom = new Random(seed);
        this.random = new ThreadLocal();
        this.formatString = formatString;
        this.decimalFormat = new ThreadLocal();
    }

    @Override
    void append(@NotNull StringBuilder buffer) {
        Random r = this.random.get();
        if (r == null) {
            r = new Random(this.seedRandom.nextLong());
            this.random.set(r);
        }
        long value = (r.nextLong() & Integer.MAX_VALUE) % this.span + this.lowerBound;
        if (this.formatString == null) {
            buffer.append(value);
        } else {
            DecimalFormat f = this.decimalFormat.get();
            if (f == null) {
                f = new DecimalFormat(this.formatString);
                this.decimalFormat.set(f);
            }
            buffer.append(f.format(value));
        }
    }

    @Override
    boolean supportsBackReference() {
        return true;
    }
}

