/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import jakarta.mail.Flags;
import java.io.Serializable;
import java.util.Collection;
import org.apache.james.jmap.core.SetError;
import org.apache.james.jmap.core.SetError$;
import org.apache.james.jmap.json.EmailSetSerializer;
import org.apache.james.jmap.mail.EmailSet$;
import org.apache.james.jmap.mail.EmailSetRequest;
import org.apache.james.jmap.mail.Keywords;
import org.apache.james.jmap.mail.KeywordsFactory$;
import org.apache.james.jmap.mail.MailboxIds;
import org.apache.james.jmap.mail.UnparsedMessageId;
import org.apache.james.jmap.mail.ValidatedEmailSetUpdate;
import org.apache.james.jmap.method.EmailSetUpdatePerformer$;
import org.apache.james.jmap.method.EmailSetUpdatePerformer$EmailUpdateSuccess$;
import org.apache.james.jmap.method.MessageNotFoundException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.OverQuotaException;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageRange;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsValue;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0011ut!B1c\u0011\u0003ig!B8c\u0011\u0003\u0001\b\"B<\u0002\t\u0003A\bbB=\u0002\u0005\u0004%IA\u001f\u0005\b\u0003\u0007\t\u0001\u0015!\u0003|\u0011%\t)!\u0001b\u0001\n\u0013\t9\u0001\u0003\u0005\u0002\u0010\u0005\u0001\u000b\u0011BA\u0005\r%\t\t\"\u0001I\u0001$\u0003\t\u0019B\u0002\u0004\u0002\u0016\u0005\u0001\u0015q\u0003\u0005\u000b\u0003wA!Q3A\u0005\u0002\u0005u\u0002BCA(\u0011\tE\t\u0015!\u0003\u0002@!1q\u000f\u0003C\u0001\u0003#B\u0011\"a\u0016\t\u0003\u0003%\t!!\u0017\t\u0013\u0005u\u0003\"%A\u0005\u0002\u0005}\u0003\"CA;\u0011\u0005\u0005I\u0011IA<\u0011%\tI\tCA\u0001\n\u0003\t9\u0001C\u0005\u0002\f\"\t\t\u0011\"\u0001\u0002\u000e\"I\u0011\u0011\u0014\u0005\u0002\u0002\u0013\u0005\u00131\u0014\u0005\n\u0003SC\u0011\u0011!C\u0001\u0003WC\u0011\"!.\t\u0003\u0003%\t%a.\t\u0013\u0005m\u0006\"!A\u0005B\u0005u\u0006\"CA`\u0011\u0005\u0005I\u0011IAa\u0011%\t\u0019\rCA\u0001\n\u0003\n)mB\u0005\u0002J\u0006\t\t\u0011#\u0001\u0002L\u001aI\u0011QC\u0001\u0002\u0002#\u0005\u0011Q\u001a\u0005\u0007ob!\t!!:\t\u0013\u0005}\u0006$!A\u0005F\u0005\u0005\u0007\"CAt1\u0005\u0005I\u0011QAu\u0011%\ti\u000fGA\u0001\n\u0003\u000by\u000fC\u0005\u0002|b\t\t\u0011\"\u0003\u0002~\u001a1!QA\u0001A\u0005\u000fA!B!\u0003\u001f\u0005+\u0007I\u0011\u0001B\u0006\u0011)\u0011IB\bB\tB\u0003%!Q\u0002\u0005\u000b\u00057q\"Q3A\u0005\u0002\tu\u0001B\u0003B\u0013=\tE\t\u0015!\u0003\u0003 !1qO\bC\u0001\u0005OAqAa\f\u001f\t\u0003\u0011\t\u0004C\u0005\u0002Xy\t\t\u0011\"\u0001\u0003@!I\u0011Q\f\u0010\u0012\u0002\u0013\u0005!Q\t\u0005\n\u0005\u0013r\u0012\u0013!C\u0001\u0005\u0017B\u0011\"!\u001e\u001f\u0003\u0003%\t%a\u001e\t\u0013\u0005%e$!A\u0005\u0002\u0005\u001d\u0001\"CAF=\u0005\u0005I\u0011\u0001B(\u0011%\tIJHA\u0001\n\u0003\nY\nC\u0005\u0002*z\t\t\u0011\"\u0001\u0003T!I\u0011Q\u0017\u0010\u0002\u0002\u0013\u0005#q\u000b\u0005\n\u0003ws\u0012\u0011!C!\u0003{C\u0011\"a0\u001f\u0003\u0003%\t%!1\t\u0013\u0005\rg$!A\u0005B\tms!\u0003B0\u0003\u0005\u0005\t\u0012\u0001B1\r%\u0011)!AA\u0001\u0012\u0003\u0011\u0019\u0007\u0003\u0004xe\u0011\u0005!1\u000e\u0005\n\u0003\u007f\u0013\u0014\u0011!C#\u0003\u0003D\u0011\"a:3\u0003\u0003%\tI!\u001c\t\u0013\u00055('!A\u0005\u0002\nM\u0004\"CA~e\u0005\u0005I\u0011BA\u007f\r\u0019\u0011y(\u0001!\u0003\u0002\"Q!1\u0011\u001d\u0003\u0016\u0004%\tA!\"\t\u0015\t5\u0005H!E!\u0002\u0013\u00119\t\u0003\u0004xq\u0011\u0005!q\u0012\u0005\b\u0005+CD\u0011\u0001BL\u0011\u001d\u0011\t\f\u000fC\u0001\u0005gC\u0011\"a\u00169\u0003\u0003%\tA!/\t\u0013\u0005u\u0003(%A\u0005\u0002\tu\u0006\"CA;q\u0005\u0005I\u0011IA<\u0011%\tI\tOA\u0001\n\u0003\t9\u0001C\u0005\u0002\fb\n\t\u0011\"\u0001\u0003B\"I\u0011\u0011\u0014\u001d\u0002\u0002\u0013\u0005\u00131\u0014\u0005\n\u0003SC\u0014\u0011!C\u0001\u0005\u000bD\u0011\"!.9\u0003\u0003%\tE!3\t\u0013\u0005m\u0006(!A\u0005B\u0005u\u0006\"CA`q\u0005\u0005I\u0011IAa\u0011%\t\u0019\rOA\u0001\n\u0003\u0012imB\u0005\u0003R\u0006\t\t\u0011#\u0001\u0003T\u001aI!qP\u0001\u0002\u0002#\u0005!Q\u001b\u0005\u0007o*#\tA!7\t\u0013\u0005}&*!A\u0005F\u0005\u0005\u0007\"CAt\u0015\u0006\u0005I\u0011\u0011Bn\u0011%\tiOSA\u0001\n\u0003\u0013y\u000eC\u0005\u0002|*\u000b\t\u0011\"\u0003\u0002~\u001a)qN\u0019\u0001\u0003f\"Q!q\u001d)\u0003\u0002\u0003\u0006IA!;\t\u0015\tU\bK!A!\u0002\u0013\u00119\u0010\u0003\u0006\u0003\u0000B\u0013\t\u0011)A\u0005\u0007\u0003A!ba\u0002Q\u0005\u0003\u0005\u000b\u0011BB\u0005\u0011\u00199\b\u000b\"\u0001\u0004\u0018!91Q\u0007)\u0005\u0002\r]\u0002bBB\u001b!\u0012%1\u0011\u0010\u0005\b\u00077\u0003F\u0011BBO\u0011\u001d\u0019Y\r\u0015C\u0005\u0007\u001bDqa!9Q\t\u0013\u0019\u0019\u000fC\u0004\u0005\u001eA#I\u0001b\b\t\u000f\u0011-\u0002\u000b\"\u0003\u0005.!9Aq\b)\u0005\n\u0011\u0005\u0003b\u0002C%!\u0012%A1\n\u0005\b\t7\u0002F\u0011\u0002C/\u0011\u001d!y\u0007\u0015C\u0005\tc\nq#R7bS2\u001cV\r^+qI\u0006$X\rU3sM>\u0014X.\u001a:\u000b\u0005\r$\u0017AB7fi\"|GM\u0003\u0002fM\u0006!!.\\1q\u0015\t9\u0007.A\u0003kC6,7O\u0003\u0002jU\u00061\u0011\r]1dQ\u0016T\u0011a[\u0001\u0004_J<7\u0001\u0001\t\u0003]\u0006i\u0011A\u0019\u0002\u0018\u000b6\f\u0017\u000e\\*fiV\u0003H-\u0019;f!\u0016\u0014hm\u001c:nKJ\u001c\"!A9\u0011\u0005I,X\"A:\u000b\u0003Q\fQa]2bY\u0006L!A^:\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQ.\u0001\u0004M\u001f\u001e;UIU\u000b\u0002wB\u0011Ap`\u0007\u0002{*\u0011aP[\u0001\u0006g24GG[\u0005\u0004\u0003\u0003i(A\u0002'pO\u001e,'/A\u0004M\u001f\u001e;UI\u0015\u0011\u0002\u001fI\u000bejR#`)\"\u0013Vi\u0015%P\u0019\u0012+\"!!\u0003\u0011\u0007I\fY!C\u0002\u0002\u000eM\u00141!\u00138u\u0003A\u0011\u0016IT$F?RC%+R*I\u001f2#\u0005EA\tF[\u0006LG.\u00169eCR,'+Z:vYR\u001c\"aB9\u0003%\u0015k\u0017-\u001b7Va\u0012\fG/Z*vG\u000e,7o]\n\t\u0011E\fI\"!\b\u0002$A\u0019\u00111D\u0004\u000e\u0003\u0005\u00012A]A\u0010\u0013\r\t\tc\u001d\u0002\b!J|G-^2u!\u0011\t)#!\u000e\u000f\t\u0005\u001d\u0012\u0011\u0007\b\u0005\u0003S\ty#\u0004\u0002\u0002,)\u0019\u0011Q\u00067\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0018bAA\u001ag\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u001c\u0003s\u0011AbU3sS\u0006d\u0017N_1cY\u0016T1!a\rt\u0003%iWm]:bO\u0016LE-\u0006\u0002\u0002@A!\u0011\u0011IA&\u001b\t\t\u0019E\u0003\u0003\u0002F\u0005\u001d\u0013!B7pI\u0016d'bAA%M\u00069Q.Y5mE>D\u0018\u0002BA'\u0003\u0007\u0012\u0011\"T3tg\u0006<W-\u00133\u0002\u00155,7o]1hK&#\u0007\u0005\u0006\u0003\u0002T\u0005U\u0003cAA\u000e\u0011!9\u00111H\u0006A\u0002\u0005}\u0012\u0001B2paf$B!a\u0015\u0002\\!I\u00111\b\u0007\u0011\u0002\u0003\u0007\u0011qH\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tG\u000b\u0003\u0002@\u0005\r4FAA3!\u0011\t9'!\u001d\u000e\u0005\u0005%$\u0002BA6\u0003[\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=4/\u0001\u0006b]:|G/\u0019;j_:LA!a\u001d\u0002j\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\b\u0005\u0003\u0002|\u0005\u0015UBAA?\u0015\u0011\ty(!!\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0007\u000bAA[1wC&!\u0011qQA?\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAH\u0003+\u00032A]AI\u0013\r\t\u0019j\u001d\u0002\u0004\u0003:L\b\"CAL!\u0005\u0005\t\u0019AA\u0005\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u0014\t\u0007\u0003?\u000b)+a$\u000e\u0005\u0005\u0005&bAARg\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u001d\u0016\u0011\u0015\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002.\u0006M\u0006c\u0001:\u00020&\u0019\u0011\u0011W:\u0003\u000f\t{w\u000e\\3b]\"I\u0011q\u0013\n\u0002\u0002\u0003\u0007\u0011qR\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002z\u0005e\u0006\"CAL'\u0005\u0005\t\u0019AA\u0005\u0003!A\u0017m\u001d5D_\u0012,GCAA\u0005\u0003!!xn\u0015;sS:<GCAA=\u0003\u0019)\u0017/^1mgR!\u0011QVAd\u0011%\t9JFA\u0001\u0002\u0004\ty)\u0001\nF[\u0006LG.\u00169eCR,7+^2dKN\u001c\bcAA\u000e1M)\u0001$a4\u0002\\BA\u0011\u0011[Al\u0003\u007f\t\u0019&\u0004\u0002\u0002T*\u0019\u0011Q[:\u0002\u000fI,h\u000e^5nK&!\u0011\u0011\\Aj\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\t\u0005\u0003;\f\u0019/\u0004\u0002\u0002`*!\u0011\u0011]AA\u0003\tIw.\u0003\u0003\u00028\u0005}GCAAf\u0003\u0015\t\u0007\u000f\u001d7z)\u0011\t\u0019&a;\t\u000f\u0005m2\u00041\u0001\u0002@\u00059QO\\1qa2LH\u0003BAy\u0003o\u0004RA]Az\u0003\u007fI1!!>t\u0005\u0019y\u0005\u000f^5p]\"I\u0011\u0011 \u000f\u0002\u0002\u0003\u0007\u00111K\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAA\u0000!\u0011\tYH!\u0001\n\t\t\r\u0011Q\u0010\u0002\u0007\u001f\nTWm\u0019;\u0003%\u0015k\u0017-\u001b7Va\u0012\fG/\u001a$bS2,(/Z\n\t=E\fI\"!\b\u0002$\u0005\tRO\u001c9beN,G-T3tg\u0006<W-\u00133\u0016\u0005\t5\u0001\u0003\u0002B\b\u0005+i!A!\u0005\u000b\u0007\tMA-\u0001\u0003nC&d\u0017\u0002\u0002B\f\u0005#\u0011\u0011#\u00168qCJ\u001cX\rZ'fgN\fw-Z%e\u0003I)h\u000e]1sg\u0016$W*Z:tC\u001e,\u0017\n\u001a\u0011\u0002\u0003\u0015,\"Aa\b\u0011\t\u0005\u0015\"\u0011E\u0005\u0005\u0005G\tIDA\u0005UQJ|w/\u00192mK\u0006\u0011Q\r\t\u000b\u0007\u0005S\u0011YC!\f\u0011\u0007\u0005ma\u0004C\u0004\u0003\n\r\u0002\rA!\u0004\t\u000f\tm1\u00051\u0001\u0003 \u0005\t\u0012m]'fgN\fw-Z*fi\u0016\u0013(o\u001c:\u0016\u0005\tM\u0002\u0003\u0002B\u001b\u0005wi!Aa\u000e\u000b\u0007\teB-\u0001\u0003d_J,\u0017\u0002\u0002B\u001f\u0005o\u0011\u0001bU3u\u000bJ\u0014xN\u001d\u000b\u0007\u0005S\u0011\tEa\u0011\t\u0013\t%Q\u0005%AA\u0002\t5\u0001\"\u0003B\u000eKA\u0005\t\u0019\u0001B\u0010+\t\u00119E\u000b\u0003\u0003\u000e\u0005\r\u0014AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005\u001bRCAa\b\u0002dQ!\u0011q\u0012B)\u0011%\t9JKA\u0001\u0002\u0004\tI\u0001\u0006\u0003\u0002.\nU\u0003\"CALY\u0005\u0005\t\u0019AAH)\u0011\tIH!\u0017\t\u0013\u0005]U&!AA\u0002\u0005%A\u0003BAW\u0005;B\u0011\"a&1\u0003\u0003\u0005\r!a$\u0002%\u0015k\u0017-\u001b7Va\u0012\fG/\u001a$bS2,(/\u001a\t\u0004\u00037\u00114#\u0002\u001a\u0003f\u0005m\u0007CCAi\u0005O\u0012iAa\b\u0003*%!!\u0011NAj\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0005C\"bA!\u000b\u0003p\tE\u0004b\u0002B\u0005k\u0001\u0007!Q\u0002\u0005\b\u00057)\u0004\u0019\u0001B\u0010)\u0011\u0011)H! \u0011\u000bI\f\u0019Pa\u001e\u0011\u000fI\u0014IH!\u0004\u0003 %\u0019!1P:\u0003\rQ+\b\u000f\\33\u0011%\tIPNA\u0001\u0002\u0004\u0011IC\u0001\nF[\u0006LG.\u00169eCR,'+Z:vYR\u001c8C\u0002\u001dr\u0003;\t\u0019#A\u0004sKN,H\u000e^:\u0016\u0005\t\u001d\u0005CBA\u0013\u0005\u0013\u000bI\"\u0003\u0003\u0003\f\u0006e\"aA*fc\u0006A!/Z:vYR\u001c\b\u0005\u0006\u0003\u0003\u0012\nM\u0005cAA\u000eq!9!1Q\u001eA\u0002\t\u001d\u0015aB;qI\u0006$X\rZ\u000b\u0003\u00053\u0003RA]Az\u00057\u0003\u0002B!(\u0003&\u0006}\"1\u0016\b\u0005\u0005?\u0013\t\u000bE\u0002\u0002*ML1Aa)t\u0003\u0019\u0001&/\u001a3fM&!!q\u0015BU\u0005\ri\u0015\r\u001d\u0006\u0004\u0005G\u001b\bc\u0001:\u0003.&\u0019!qV:\u0003\tUs\u0017\u000e^\u0001\u000b]>$X\u000b\u001d3bi\u0016$WC\u0001B[!\u0015\u0011\u00181\u001fB\\!!\u0011iJ!*\u0003\u000e\tMB\u0003\u0002BI\u0005wC\u0011Ba!?!\u0003\u0005\rAa\"\u0016\u0005\t}&\u0006\u0002BD\u0003G\"B!a$\u0003D\"I\u0011q\u0013\"\u0002\u0002\u0003\u0007\u0011\u0011\u0002\u000b\u0005\u0003[\u00139\rC\u0005\u0002\u0018\u0012\u000b\t\u00111\u0001\u0002\u0010R!\u0011\u0011\u0010Bf\u0011%\t9*RA\u0001\u0002\u0004\tI\u0001\u0006\u0003\u0002.\n=\u0007\"CAL\u0011\u0006\u0005\t\u0019AAH\u0003I)U.Y5m+B$\u0017\r^3SKN,H\u000e^:\u0011\u0007\u0005m!jE\u0003K\u0005/\fY\u000e\u0005\u0005\u0002R\u0006]'q\u0011BI)\t\u0011\u0019\u000e\u0006\u0003\u0003\u0012\nu\u0007b\u0002BB\u001b\u0002\u0007!q\u0011\u000b\u0005\u0005C\u0014\u0019\u000fE\u0003s\u0003g\u00149\tC\u0005\u0002z:\u000b\t\u00111\u0001\u0003\u0012N\u0011\u0001+]\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0003\u0002Bv\u0005cl!A!<\u000b\u0007\t=H-\u0001\u0003kg>t\u0017\u0002\u0002Bz\u0005[\u0014!#R7bS2\u001cV\r^*fe&\fG.\u001b>fe\u0006\u0001R.Z:tC\u001e,\u0017\nZ'b]\u0006<WM\u001d\t\u0005\u0005s\u0014Y0\u0004\u0002\u0002H%!!Q`A$\u0005AiUm]:bO\u0016LE-T1oC\u001e,'/\u0001\bnC&d'm\u001c=NC:\fw-\u001a:\u0011\t\te81A\u0005\u0005\u0007\u000b\t9E\u0001\bNC&d'm\u001c=NC:\fw-\u001a:\u0002!5,7o]1hK&#g)Y2u_JL\b\u0003BB\u0006\u0007#qA!!\u0011\u0004\u000e%!1qBA\"\u0003%iUm]:bO\u0016LE-\u0003\u0003\u0004\u0014\rU!a\u0002$bGR|'/\u001f\u0006\u0005\u0007\u001f\t\u0019\u0005\u0006\u0006\u0004\u001a\rm1QDB\u0010\u0007C\u0001\"A\u001c)\t\u000f\t\u001dX\u000b1\u0001\u0003j\"9!Q_+A\u0002\t]\bb\u0002B\u0000+\u0002\u00071\u0011\u0001\u0005\b\u0007\u000f)\u0006\u0019AB\u0005Q\r)6Q\u0005\t\u0005\u0007O\u0019\t$\u0004\u0002\u0004*)!11FB\u0017\u0003\u0019IgN[3di*\u00111qF\u0001\bU\u0006\\\u0017M\u001d;b\u0013\u0011\u0019\u0019d!\u000b\u0003\r%s'.Z2u\u0003\u0019)\b\u000fZ1uKR11\u0011HB3\u0007_\u0002baa\u000f\u0004J\r5SBAB\u001f\u0015\u0011\u0019yd!\u0011\u0002\u0013A,(\r\\5tQ\u0016\u0014(b\u0001;\u0004D)!!\u0011HB#\u0015\t\u00199%A\u0004sK\u0006\u001cGo\u001c:\n\t\r-3Q\b\u0002\u0006'6{gn\u001c\t\u0004\u0007\u001fBdbAB)\u00019!11KB2\u001d\u0011\u0019)f!\u0019\u000f\t\r]3q\f\b\u0005\u00073\u001aiF\u0004\u0003\u0002*\rm\u0013\"A6\n\u0005%T\u0017BA4i\u0013\t)g-\u0003\u0002dI\"91q\r,A\u0002\r%\u0014aD3nC&d7+\u001a;SKF,Xm\u001d;\u0011\t\t=11N\u0005\u0005\u0007[\u0012\tBA\bF[\u0006LGnU3u%\u0016\fX/Z:u\u0011\u001d\u0019\tH\u0016a\u0001\u0007g\na\"\\1jY\n|\u0007pU3tg&|g\u000e\u0005\u0003\u0003z\u000eU\u0014\u0002BB<\u0003\u000f\u0012a\"T1jY\n|\u0007pU3tg&|g\u000e\u0006\u0004\u0004:\rm4q\u0013\u0005\b\u0007{:\u0006\u0019AB@\u0003\u001d)\b\u000fZ1uKN\u0004\u0002B!(\u0003&\n51\u0011\u0011\t\u0005\u0007\u0007\u001b\u0019*\u0004\u0002\u0004\u0006*!!q^BD\u0015\u0011\u0019Iia#\u0002\t1L'm\u001d\u0006\u0005\u0007\u001b\u001by)A\u0002ba&T!a!%\u0002\tAd\u0017-_\u0005\u0005\u0007+\u001b)I\u0001\u0005Kg>\u0013'.Z2u\u0011\u001d\u0019Ij\u0016a\u0001\u0007g\nqa]3tg&|g.\u0001\u0005e_V\u0003H-\u0019;f)!\u0019yj!*\u00048\u000e%\u0007CBB\u001e\u0007\u0013\u001a\t\u000b\u0005\u0004\u0002&\t%51\u0015\t\u0004\u0007\u001f:\u0001bBBT1\u0002\u00071\u0011V\u0001\rm\u0006d\u0017\u000eZ+qI\u0006$Xm\u001d\t\u0007\u0003K\u0019Yka,\n\t\r5\u0016\u0011\b\u0002\u0005\u0019&\u001cH\u000fE\u0004s\u0005s\nyd!-\u0011\t\t=11W\u0005\u0005\u0007k\u0013\tBA\fWC2LG-\u0019;fI\u0016k\u0017-\u001b7TKR,\u0006\u000fZ1uK\"91\u0011\u0018-A\u0002\rm\u0016\u0001C7fi\u0006$\u0015\r^1\u0011\u0011\tu%QUA \u0007{\u0003b!!\n\u0004@\u000e\r\u0017\u0002BBa\u0003s\u0011\u0001\"\u0013;fe\u0006\u0014G.\u001a\t\u0005\u0003\u0003\u001a)-\u0003\u0003\u0004H\u0006\r#!H\"p[B|7/\u001a3NKN\u001c\u0018mZ3JI^KG\u000f['fi\u0006$\u0015\r^1\t\u000f\re\u0005\f1\u0001\u0004t\u0005A\u0011m\u001d*b]\u001e,7\u000f\u0006\u0003\u0004P\u000e}\u0007CBBi\u0007/\u001cI.\u0004\u0002\u0004T*!1Q[AQ\u0003%IW.\\;uC\ndW-\u0003\u0003\u0004.\u000eM\u0007\u0003BA!\u00077LAa!8\u0002D\taQ*Z:tC\u001e,'+\u00198hK\"91\u0011X-A\u0002\rm\u0016AE;qI\u0006$XM\u00127bON\u0014\u0015PU1oO\u0016$bba(\u0004f\u000e=8Q C\u0002\t\u000b!Y\u0002C\u0004\u0004hj\u0003\ra!;\u0002\u00135\f\u0017\u000e\u001c2pq&#\u0007\u0003BA!\u0007WLAa!<\u0002D\tIQ*Y5mE>D\u0018\n\u001a\u0005\b\u0007cT\u0006\u0019ABz\u0003\u00151G.Y4t!\u0011\u0019)p!?\u000e\u0005\r](\u0002\u0002B\n\u0007[IAaa?\u0004x\n)a\t\\1hg\"91q .A\u0002\u0011\u0005\u0011A\u0002:b]\u001e,7\u000f\u0005\u0004\u0002&\r-6\u0011\u001c\u0005\b\u0007sS\u0006\u0019AB^\u0011\u001d!9A\u0017a\u0001\t\u0013\t!\"\u001e9eCR,Wj\u001c3f!\u0011!Y\u0001\"\u0006\u000f\t\u00115A\u0011\u0003\b\u0005\u0007+\"y!C\u0002\u0002J\u0019LA\u0001b\u0005\u0002H\u0005qQ*Z:tC\u001e,W*\u00198bO\u0016\u0014\u0018\u0002\u0002C\f\t3\u0011qB\u00127bON,\u0006\u000fZ1uK6{G-\u001a\u0006\u0005\t'\t9\u0005C\u0004\u0004\u001aj\u0003\raa\u001d\u0002\u00175|g/\u001a\"z%\u0006tw-\u001a\u000b\r\u0007?#\t\u0003b\t\u0005&\u0011\u001dB\u0011\u0006\u0005\b\u0007O\\\u0006\u0019ABu\u0011\u001d\u0019)d\u0017a\u0001\u0007cCqaa@\\\u0001\u0004!\t\u0001C\u0004\u0004:n\u0003\raa/\t\u000f\re5\f1\u0001\u0004t\u0005iQ\u000f\u001d3bi\u0016\u0014\u0015PU1oO\u0016$\u0002ba(\u00050\u0011EB1\u0007\u0005\b\u0007\u007fd\u0006\u0019\u0001C\u0001\u0011\u001d\u0019I\f\u0018a\u0001\u0007wCq\u0001\"\u000e]\u0001\u0004!9$A\u0005pa\u0016\u0014\u0018\r^5p]B9!\u000f\"\u000f\u0004Z\u0012u\u0012b\u0001C\u001eg\nIa)\u001e8di&|g.\r\t\u0007\u0007w\u0019IEa+\u0002#U\u0004H-\u0019;f\u000b\u0006\u001c\u0007.T3tg\u0006<W\r\u0006\u0005\u0004 \u0012\rCQ\tC$\u0011\u001d\u00199+\u0018a\u0001\u0007SCqa!/^\u0001\u0004\u0019Y\fC\u0004\u0004\u001av\u0003\raa\u001d\u0002'U\u0004H-\u0019;f'&tw\r\\3NKN\u001c\u0018mZ3\u0015\u0015\u00115Cq\nC)\t'\"I\u0006\u0005\u0004\u0004<\r%31\u0015\u0005\b\u0003wq\u0006\u0019AA \u0011\u001d\u0019)D\u0018a\u0001\u0007cCq\u0001\"\u0016_\u0001\u0004!9&\u0001\bti>\u0014X\rZ'fi\u0006$\u0015\r^1\u0011\r\u0005\u001521VBb\u0011\u001d\u0019IJ\u0018a\u0001\u0007g\n\u0001#\u001e9eCR,W*Y5mE>D\u0018\nZ:\u0015\u0015\u00115Cq\fC1\tG\"i\u0007C\u0004\u0002<}\u0003\r!a\u0010\t\u000f\rUr\f1\u0001\u00042\"9AQM0A\u0002\u0011\u001d\u0014AC7bS2\u0014w\u000e_%egB!!q\u0002C5\u0013\u0011!YG!\u0005\u0003\u00155\u000b\u0017\u000e\u001c2pq&#7\u000fC\u0004\u0004\u001a~\u0003\raa\u001d\u0002\u0017U\u0004H-\u0019;f\r2\fwm\u001d\u000b\r\t\u001b\"\u0019\b\"\u001e\u0005x\u0011eD1\u0010\u0005\b\u0003w\u0001\u0007\u0019AA \u0011\u001d\u0019)\u0004\u0019a\u0001\u0007cCq\u0001\"\u001aa\u0001\u0004!9\u0007C\u0004\u0005V\u0001\u0004\r\u0001b\u0016\t\u000f\re\u0005\r1\u0001\u0004t\u0001")
public class EmailSetUpdatePerformer {
    private final EmailSetSerializer serializer;
    private final MessageIdManager messageIdManager;
    private final MailboxManager mailboxManager;
    private final MessageId.Factory messageIdFactory;

    public SMono<EmailUpdateResults> update(EmailSetRequest emailSetRequest, MailboxSession mailboxSession) {
        return (SMono)emailSetRequest.update().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.nonEmpty())).map((Function1 & Serializable)x$4 -> this.update((Map<UnparsedMessageId, JsObject>)x$4, mailboxSession)).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.just((Object)new EmailUpdateResults((scala.collection.immutable.Seq<EmailUpdateResult>)((scala.collection.immutable.Seq)Nil$.MODULE$))));
    }

    private SMono<EmailUpdateResults> update(Map<UnparsedMessageId, JsObject> updates2, MailboxSession session) {
        List validatedUpdates = ((IterableOnceOps)updates2.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                UnparsedMessageId unparsedMessageId = (UnparsedMessageId)tuple2._1();
                JsObject json = (JsObject)tuple2._2();
                return EmailSet$.MODULE$.parse($this.messageIdFactory, unparsedMessageId).toEither().left().map((Function1 & Serializable)e -> new EmailUpdateFailure(unparsedMessageId, (Throwable)e)).flatMap((Function1 & Serializable)id -> (Either)$this.serializer.deserializeEmailSetUpdate((JsValue)json).asEither().left().map((Function1 & Serializable)e -> new IllegalArgumentException(e.toString())).flatMap((Function1 & Serializable)x$5 -> x$5.validate()).fold((Function1 & Serializable)e -> new Left((Object)new EmailUpdateFailure(unparsedMessageId, (Throwable)e)), (Function1 & Serializable)emailSetUpdate -> new Right((Object)new Tuple2(id, emailSetUpdate))));
            }
            throw new MatchError((Object)tuple2);
        })).toList();
        List failures = validatedUpdates.flatMap((Function1 & Serializable)x0$2 -> {
            Either either = x0$2;
            if (either instanceof Left) {
                Left left = (Left)either;
                EmailUpdateFailure e = (EmailUpdateFailure)left.value();
                return new Some((Object)e);
            }
            return None$.MODULE$;
        });
        List validUpdates = validatedUpdates.flatMap((Function1 & Serializable)x0$3 -> {
            Either either = x0$3;
            if (either instanceof Right) {
                Right right = (Right)either;
                Tuple2 pair = (Tuple2)right.value();
                return new Some((Object)pair);
            }
            return None$.MODULE$;
        });
        return SFlux$.MODULE$.fromPublisher(this.messageIdManager.messagesMetadata(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)validUpdates.map((Function1 & Serializable)x$6 -> (MessageId)x$6._1())).asJavaCollection(), session)).collectMultimap((Function1 & Serializable)metaData -> metaData.getComposedMessageId().getMessageId()).flatMap((Function1 & Serializable)x$7 -> this.doUpdate((List<Tuple2<MessageId, ValidatedEmailSetUpdate>>)validUpdates, (Map<MessageId, Iterable<ComposedMessageIdWithMetaData>>)x$7, session)).map((Function1 & Serializable)updates -> new EmailUpdateResults((scala.collection.immutable.Seq<EmailUpdateResult>)((scala.collection.immutable.Seq)updates.$plus$plus((IterableOnce)failures))));
    }

    private SMono<scala.collection.immutable.Seq<EmailUpdateResult>> doUpdate(List<Tuple2<MessageId, ValidatedEmailSetUpdate>> validUpdates, Map<MessageId, Iterable<ComposedMessageIdWithMetaData>> metaData, MailboxSession session) {
        boolean singleMailbox;
        boolean sameUpdate = ((SeqOps)validUpdates.map((Function1 & Serializable)x$8 -> (ValidatedEmailSetUpdate)x$8._2()).distinctBy((Function1 & Serializable)x$9 -> x$9.update())).size() == 1;
        boolean bl = singleMailbox = ((IterableOnceOps)((IterableOps)metaData.values().flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)x$10 -> x$10.getComposedMessageId().getMailboxId())).toSet().size() == 1;
        if (sameUpdate && singleMailbox && validUpdates.size() > EmailSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$EmailSetUpdatePerformer$$RANGE_THRESHOLD()) {
            ValidatedEmailSetUpdate update = (ValidatedEmailSetUpdate)validUpdates.map((Function1 & Serializable)x$11 -> (ValidatedEmailSetUpdate)x$11._2()).headOption().get();
            List<MessageRange> ranges = this.asRanges(metaData);
            MailboxId mailboxId = (MailboxId)((IterableOps)((IterableOps)metaData.values().flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)x$12 -> x$12.getComposedMessageId().getMailboxId())).headOption().get();
            if (update.update().isOnlyFlagAddition()) {
                return this.updateFlagsByRange(mailboxId, ((Keywords)update.update().keywordsToAdd().get()).asFlags(), ranges, metaData, MessageManager.FlagsUpdateMode.ADD, session);
            }
            if (update.update().isOnlyFlagRemoval()) {
                return this.updateFlagsByRange(mailboxId, ((Keywords)update.update().keywordsToRemove().get()).asFlags(), ranges, metaData, MessageManager.FlagsUpdateMode.REMOVE, session);
            }
            if (update.update().isOnlyMove()) {
                return this.moveByRange(mailboxId, update, ranges, metaData, session);
            }
            return this.updateEachMessage(validUpdates, metaData, session);
        }
        return this.updateEachMessage(validUpdates, metaData, session);
    }

    private List<MessageRange> asRanges(Map<MessageId, Iterable<ComposedMessageIdWithMetaData>> metaData) {
        return CollectionConverters$.MODULE$.ListHasAsScala(MessageRange.toRanges((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)((IterableOps)metaData.values().flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)x$13 -> x$13.getComposedMessageId().getUid())).toList().distinct()).asJava())).asScala().toList();
    }

    private SMono<scala.collection.immutable.Seq<EmailUpdateResult>> updateFlagsByRange(MailboxId mailboxId, Flags flags, List<MessageRange> ranges, Map<MessageId, Iterable<ComposedMessageIdWithMetaData>> metaData, MessageManager.FlagsUpdateMode updateMode, MailboxSession session) {
        SMono mailboxMono = SMono$.MODULE$.apply(this.mailboxManager.getMailboxReactive(mailboxId, session));
        return mailboxMono.flatMap((Function1 & Serializable)mailbox -> this.updateByRange(ranges, metaData, (Function1<MessageRange, SMono<BoxedUnit>>)(Function1 & Serializable)range -> SMono$.MODULE$.apply(mailbox.setFlagsReactive(flags, updateMode, range, session)).then()));
    }

    private SMono<scala.collection.immutable.Seq<EmailUpdateResult>> moveByRange(MailboxId mailboxId, ValidatedEmailSetUpdate update, List<MessageRange> ranges, Map<MessageId, Iterable<ComposedMessageIdWithMetaData>> metaData, MailboxSession session) {
        MailboxId targetId = (MailboxId)((MailboxIds)update.update().mailboxIds().get()).value().headOption().get();
        return this.updateByRange(ranges, metaData, (Function1<MessageRange, SMono<BoxedUnit>>)(Function1 & Serializable)range -> SMono$.MODULE$.apply($this.mailboxManager.moveMessagesReactive(range, mailboxId, targetId, session)).then());
    }

    private SMono<scala.collection.immutable.Seq<EmailUpdateResult>> updateByRange(List<MessageRange> ranges, Map<MessageId, Iterable<ComposedMessageIdWithMetaData>> metaData, Function1<MessageRange, SMono<BoxedUnit>> operation) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable(ranges);
        Function1 & Serializable x$1 = (Function1 & Serializable)range -> {
            scala.collection.immutable.Seq messageIds = ((MapOps)metaData.filter((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)EmailSetUpdatePerformer.$anonfun$updateByRange$2(range, entry)))).keys().toSeq();
            return ((SMono)operation.apply(range)).then(SMono$.MODULE$.just(messageIds.map((Function1)EmailSetUpdatePerformer$EmailUpdateSuccess$.MODULE$))).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just(messageIds.map((Function1 & Serializable)id -> new EmailUpdateFailure(EmailSet$.MODULE$.asUnparsed((MessageId)id), (Throwable)e))));
        };
        int x$2 = qual$1.concatMap$default$2();
        return qual$1.concatMap((Function1)x$1, x$2).reduce((Object)Nil$.MODULE$, (Function2 & Serializable)(x$14, x$15) -> (scala.collection.immutable.Seq)x$14.$plus$plus((IterableOnce)x$15));
    }

    private SMono<scala.collection.immutable.Seq<EmailUpdateResult>> updateEachMessage(List<Tuple2<MessageId, ValidatedEmailSetUpdate>> validUpdates, Map<MessageId, Iterable<ComposedMessageIdWithMetaData>> metaData, MailboxSession session) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable(validUpdates);
        Function1 & Serializable x$1 = (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                MessageId messageId = (MessageId)tuple2._1();
                ValidatedEmailSetUpdate updatePatch = (ValidatedEmailSetUpdate)tuple2._2();
                return this.updateSingleMessage(messageId, updatePatch, (List<ComposedMessageIdWithMetaData>)((List)metaData.get((Object)messageId).toList().flatten(Predef$.MODULE$.$conforms())), session);
            }
            throw new MatchError((Object)tuple2);
        };
        int x$2 = qual$1.concatMap$default$2();
        return qual$1.concatMap((Function1)x$1, x$2).collectSeq();
    }

    private SMono<EmailUpdateResult> updateSingleMessage(MessageId messageId, ValidatedEmailSetUpdate update, List<ComposedMessageIdWithMetaData> storedMetaData, MailboxSession session) {
        MailboxIds mailboxIds = new MailboxIds((List<MailboxId>)storedMetaData.map((Function1 & Serializable)metaData -> metaData.getComposedMessageId().getMailboxId()));
        if (mailboxIds.value().isEmpty()) {
            return SMono$.MODULE$.just((Object)new EmailUpdateFailure(EmailSet$.MODULE$.asUnparsed(messageId), new MessageNotFoundException(messageId)));
        }
        return this.updateFlags(messageId, update, mailboxIds, storedMetaData, session).flatMap((Function1 & Serializable)x0$1 -> {
            EmailUpdateResult emailUpdateResult = x0$1;
            if (emailUpdateResult instanceof EmailUpdateFailure) {
                EmailUpdateFailure emailUpdateFailure = (EmailUpdateFailure)emailUpdateResult;
                return SMono$.MODULE$.just((Object)emailUpdateFailure);
            }
            if (emailUpdateResult instanceof EmailUpdateSuccess) {
                return this.updateMailboxIds(messageId, update, mailboxIds, session);
            }
            throw new MatchError((Object)emailUpdateResult);
        }).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new EmailUpdateFailure(EmailSet$.MODULE$.asUnparsed(messageId), (Throwable)e))).switchIfEmpty(SMono$.MODULE$.just((Object)new EmailUpdateSuccess(messageId)));
    }

    private SMono<EmailUpdateResult> updateMailboxIds(MessageId messageId, ValidatedEmailSetUpdate update, MailboxIds mailboxIds, MailboxSession session) {
        if (update.update().isMailboxUpdate()) {
            MailboxIds targetIds = (MailboxIds)update.mailboxIdsTransformation().apply((Object)mailboxIds);
            return SMono$.MODULE$.apply(this.messageIdManager.setInMailboxesReactive(messageId, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(targetIds.value()).asJava(), session)).then(SMono$.MODULE$.just((Object)new EmailUpdateSuccess(messageId))).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new EmailUpdateFailure(EmailSet$.MODULE$.asUnparsed(messageId), (Throwable)e))).switchIfEmpty(SMono$.MODULE$.just((Object)new EmailUpdateSuccess(messageId)));
        }
        return SMono$.MODULE$.just((Object)new EmailUpdateSuccess(messageId));
    }

    private SMono<EmailUpdateResult> updateFlags(MessageId messageId, ValidatedEmailSetUpdate update, MailboxIds mailboxIds, List<ComposedMessageIdWithMetaData> storedMetaData, MailboxSession session) {
        if (update.update().isFlagUpdate()) {
            Flags originalFlags = (Flags)storedMetaData.foldLeft((Object)new Flags(), (Function2 & Serializable)(flags, m) -> {
                flags.add(m.getFlags());
                return flags;
            });
            Flags newFlags = ((Keywords)update.keywordsTransformation().apply(KeywordsFactory$.MODULE$.LENIENT_KEYWORDS_FACTORY().fromFlags(originalFlags).get())).asFlagsWithRecentAndDeletedFrom(originalFlags);
            return SMono$.MODULE$.apply(this.messageIdManager.setFlagsReactive(newFlags, MessageManager.FlagsUpdateMode.REPLACE, messageId, (java.util.List)ImmutableList.copyOf((Collection)CollectionConverters$.MODULE$.IterableHasAsJava(mailboxIds.value()).asJavaCollection()), session)).then(SMono$.MODULE$.just((Object)new EmailUpdateSuccess(messageId)));
        }
        return SMono$.MODULE$.just((Object)new EmailUpdateSuccess(messageId));
    }

    public static final /* synthetic */ boolean $anonfun$updateByRange$2(MessageRange range$1, Tuple2 entry) {
        return ((IterableOnceOps)entry._2()).exists((Function1 & Serializable)composedId -> BoxesRunTime.boxToBoolean((boolean)range$1.includes(composedId.getComposedMessageId().getUid())));
    }

    @Inject
    public EmailSetUpdatePerformer(EmailSetSerializer serializer, MessageIdManager messageIdManager, MailboxManager mailboxManager, MessageId.Factory messageIdFactory) {
        this.serializer = serializer;
        this.messageIdManager = messageIdManager;
        this.mailboxManager = mailboxManager;
        this.messageIdFactory = messageIdFactory;
    }

    public static class EmailUpdateFailure
    implements EmailUpdateResult,
    Product,
    Serializable {
        private final UnparsedMessageId unparsedMessageId;
        private final Throwable e;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public UnparsedMessageId unparsedMessageId() {
            return this.unparsedMessageId;
        }

        public Throwable e() {
            return this.e;
        }

        public SetError asMessageSetError() {
            Throwable throwable = this.e();
            if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                EmailSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$EmailSetUpdatePerformer$$LOGGER().info("Illegal argument in Email/set update", (Throwable)illegalArgumentException);
                return SetError$.MODULE$.invalidPatch("Message update is invalid: " + illegalArgumentException.getMessage());
            }
            if (throwable instanceof MailboxNotFoundException) {
                MailboxNotFoundException mailboxNotFoundException = (MailboxNotFoundException)throwable;
                EmailSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$EmailSetUpdatePerformer$$LOGGER().info("Mailbox not found in Email/set update", (Throwable)mailboxNotFoundException);
                return SetError$.MODULE$.notFound("Mailbox not found");
            }
            if (throwable instanceof MessageNotFoundException) {
                MessageNotFoundException messageNotFoundException = (MessageNotFoundException)throwable;
                EmailSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$EmailSetUpdatePerformer$$LOGGER().info("Message not found in Email/set update: " + messageNotFoundException.messageId().serialize());
                return SetError$.MODULE$.notFound("Cannot find message with messageId: " + messageNotFoundException.messageId().serialize());
            }
            if (throwable instanceof OverQuotaException) {
                OverQuotaException overQuotaException = (OverQuotaException)throwable;
                EmailSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$EmailSetUpdatePerformer$$LOGGER().info("Overquota in email set update");
                return SetError$.MODULE$.overQuota(overQuotaException.getMessage());
            }
            EmailSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$EmailSetUpdatePerformer$$LOGGER().error("Failed to update email", this.e());
            return SetError$.MODULE$.serverFail(this.e().getMessage());
        }

        public EmailUpdateFailure copy(UnparsedMessageId unparsedMessageId, Throwable e) {
            return new EmailUpdateFailure(unparsedMessageId, e);
        }

        public UnparsedMessageId copy$default$1() {
            return this.unparsedMessageId();
        }

        public Throwable copy$default$2() {
            return this.e();
        }

        public String productPrefix() {
            return "EmailUpdateFailure";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.unparsedMessageId();
                }
                case 1: {
                    return this.e();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof EmailUpdateFailure;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "unparsedMessageId";
                }
                case 1: {
                    return "e";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof EmailUpdateFailure)) return false;
            boolean bl = true;
            if (!bl) return false;
            EmailUpdateFailure emailUpdateFailure = (EmailUpdateFailure)x$1;
            UnparsedMessageId unparsedMessageId = this.unparsedMessageId();
            UnparsedMessageId unparsedMessageId2 = emailUpdateFailure.unparsedMessageId();
            if (unparsedMessageId == null) {
                if (unparsedMessageId2 != null) {
                    return false;
                }
            } else if (!((Object)unparsedMessageId).equals(unparsedMessageId2)) return false;
            Throwable throwable = this.e();
            Throwable throwable2 = emailUpdateFailure.e();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!emailUpdateFailure.canEqual(this)) return false;
            return true;
        }

        public EmailUpdateFailure(UnparsedMessageId unparsedMessageId, Throwable e) {
            this.unparsedMessageId = unparsedMessageId;
            this.e = e;
            Product.$init$((Product)this);
        }
    }

    public static interface EmailUpdateResult {
    }

    public static class EmailUpdateResults
    implements Product,
    Serializable {
        private final scala.collection.immutable.Seq<EmailUpdateResult> results;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public scala.collection.immutable.Seq<EmailUpdateResult> results() {
            return this.results;
        }

        public Option<Map<MessageId, BoxedUnit>> updated() {
            return Option$.MODULE$.apply((Object)((IterableOnceOps)this.results().flatMap((Function1 & Serializable)x0$1 -> {
                EmailUpdateResult emailUpdateResult = x0$1;
                if (emailUpdateResult instanceof EmailUpdateSuccess) {
                    EmailUpdateSuccess emailUpdateSuccess = (EmailUpdateSuccess)emailUpdateResult;
                    return new Some((Object)new Tuple2((Object)emailUpdateSuccess.messageId(), (Object)BoxedUnit.UNIT));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nonEmpty()));
        }

        public Option<Map<UnparsedMessageId, SetError>> notUpdated() {
            return Option$.MODULE$.apply((Object)((IterableOnceOps)this.results().flatMap((Function1 & Serializable)x0$1 -> {
                EmailUpdateResult emailUpdateResult = x0$1;
                if (emailUpdateResult instanceof EmailUpdateFailure) {
                    EmailUpdateFailure emailUpdateFailure = (EmailUpdateFailure)emailUpdateResult;
                    return new Some((Object)new Tuple2((Object)emailUpdateFailure.unparsedMessageId(), (Object)emailUpdateFailure.asMessageSetError()));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.nonEmpty()));
        }

        public EmailUpdateResults copy(scala.collection.immutable.Seq<EmailUpdateResult> results) {
            return new EmailUpdateResults(results);
        }

        public scala.collection.immutable.Seq<EmailUpdateResult> copy$default$1() {
            return this.results();
        }

        public String productPrefix() {
            return "EmailUpdateResults";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.results();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof EmailUpdateResults;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "results";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof EmailUpdateResults)) return false;
            boolean bl = true;
            if (!bl) return false;
            EmailUpdateResults emailUpdateResults = (EmailUpdateResults)x$1;
            scala.collection.immutable.Seq<EmailUpdateResult> seq = this.results();
            scala.collection.immutable.Seq<EmailUpdateResult> seq2 = emailUpdateResults.results();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!emailUpdateResults.canEqual(this)) return false;
            return true;
        }

        public EmailUpdateResults(scala.collection.immutable.Seq<EmailUpdateResult> results) {
            this.results = results;
            Product.$init$((Product)this);
        }
    }

    public static class EmailUpdateSuccess
    implements EmailUpdateResult,
    Product,
    Serializable {
        private final MessageId messageId;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public MessageId messageId() {
            return this.messageId;
        }

        public EmailUpdateSuccess copy(MessageId messageId) {
            return new EmailUpdateSuccess(messageId);
        }

        public MessageId copy$default$1() {
            return this.messageId();
        }

        public String productPrefix() {
            return "EmailUpdateSuccess";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.messageId();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof EmailUpdateSuccess;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "messageId";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof EmailUpdateSuccess)) return false;
            boolean bl = true;
            if (!bl) return false;
            EmailUpdateSuccess emailUpdateSuccess = (EmailUpdateSuccess)x$1;
            MessageId messageId = this.messageId();
            MessageId messageId2 = emailUpdateSuccess.messageId();
            if (messageId == null) {
                if (messageId2 != null) {
                    return false;
                }
            } else if (!messageId.equals(messageId2)) return false;
            if (!emailUpdateSuccess.canEqual(this)) return false;
            return true;
        }

        public EmailUpdateSuccess(MessageId messageId) {
            this.messageId = messageId;
            Product.$init$((Product)this);
        }
    }
}

