/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class Translog
implements PlainJsonSerializable {
    @Nullable
    private final String durability;
    @Nullable
    private final String flushThresholdSize;
    @Nullable
    private final Time syncInterval;
    public static final JsonpDeserializer<Translog> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Translog::setupTranslogDeserializer);

    private Translog(Builder builder) {
        this.durability = builder.durability;
        this.flushThresholdSize = builder.flushThresholdSize;
        this.syncInterval = builder.syncInterval;
    }

    public static Translog of(Function<Builder, ObjectBuilder<Translog>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String durability() {
        return this.durability;
    }

    @Nullable
    public final String flushThresholdSize() {
        return this.flushThresholdSize;
    }

    @Nullable
    public final Time syncInterval() {
        return this.syncInterval;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.durability != null) {
            generator.writeKey("durability");
            generator.write(this.durability);
        }
        if (this.flushThresholdSize != null) {
            generator.writeKey("flush_threshold_size");
            generator.write(this.flushThresholdSize);
        }
        if (this.syncInterval != null) {
            generator.writeKey("sync_interval");
            this.syncInterval.serialize(generator, mapper);
        }
    }

    protected static void setupTranslogDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::durability, JsonpDeserializer.stringDeserializer(), "durability");
        op.add(Builder::flushThresholdSize, JsonpDeserializer.stringDeserializer(), "flush_threshold_size");
        op.add(Builder::syncInterval, Time._DESERIALIZER, "sync_interval");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Translog> {
        @Nullable
        private String durability;
        @Nullable
        private String flushThresholdSize;
        @Nullable
        private Time syncInterval;

        public final Builder durability(@Nullable String value) {
            this.durability = value;
            return this;
        }

        public final Builder flushThresholdSize(@Nullable String value) {
            this.flushThresholdSize = value;
            return this;
        }

        public final Builder syncInterval(@Nullable Time value) {
            this.syncInterval = value;
            return this;
        }

        @Override
        public Translog build() {
            this._checkSingleUse();
            return new Translog(this);
        }
    }
}

