/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class InferenceTopClassEntry
implements PlainJsonSerializable {
    private final FieldValue className;
    private final double classProbability;
    private final double classScore;
    public static final JsonpDeserializer<InferenceTopClassEntry> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InferenceTopClassEntry::setupInferenceTopClassEntryDeserializer);

    private InferenceTopClassEntry(Builder builder) {
        this.className = ApiTypeHelper.requireNonNull(builder.className, this, "className");
        this.classProbability = ApiTypeHelper.requireNonNull(builder.classProbability, this, "classProbability");
        this.classScore = ApiTypeHelper.requireNonNull(builder.classScore, this, "classScore");
    }

    public static InferenceTopClassEntry of(Function<Builder, ObjectBuilder<InferenceTopClassEntry>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final FieldValue className() {
        return this.className;
    }

    public final double classProbability() {
        return this.classProbability;
    }

    public final double classScore() {
        return this.classScore;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("class_name");
        this.className.serialize(generator, mapper);
        generator.writeKey("class_probability");
        generator.write(this.classProbability);
        generator.writeKey("class_score");
        generator.write(this.classScore);
    }

    protected static void setupInferenceTopClassEntryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::className, FieldValue._DESERIALIZER, "class_name");
        op.add(Builder::classProbability, JsonpDeserializer.doubleDeserializer(), "class_probability");
        op.add(Builder::classScore, JsonpDeserializer.doubleDeserializer(), "class_score");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<InferenceTopClassEntry> {
        private FieldValue className;
        private Double classProbability;
        private Double classScore;

        public final Builder className(FieldValue value) {
            this.className = value;
            return this;
        }

        public final Builder className(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.className(fn.apply(new FieldValue.Builder()).build());
        }

        public final Builder classProbability(double value) {
            this.classProbability = value;
            return this;
        }

        public final Builder classScore(double value) {
            this.classScore = value;
            return this;
        }

        @Override
        public InferenceTopClassEntry build() {
            this._checkSingleUse();
            return new InferenceTopClassEntry(this);
        }
    }
}

