/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.protocol.internal.request;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.ProtocolErrors;
import com.datastax.oss.protocol.internal.request.Batch;
import com.datastax.oss.protocol.internal.request.query.Values;
import com.datastax.oss.protocol.internal.util.Flags;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class DseBatchCodec
extends Message.Codec {
    public DseBatchCodec(int protocolVersion) {
        super(13, protocolVersion);
        assert (protocolVersion >= 65);
    }

    @Override
    public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder) {
        Batch batch = (Batch)message;
        encoder.writeByte(batch.type, dest);
        int queryCount = batch.queriesOrIds.size();
        encoder.writeUnsignedShort(queryCount, dest);
        for (int i = 0; i < queryCount; ++i) {
            Object q = batch.queriesOrIds.get(i);
            if (q instanceof String) {
                encoder.writeByte((byte)0, dest);
                encoder.writeLongString((String)q, dest);
            } else {
                encoder.writeByte((byte)1, dest);
                encoder.writeShortBytes((byte[])q, dest);
            }
            Values.writePositionalValues(batch.values.get(i), dest, encoder);
        }
        encoder.writeUnsignedShort(batch.consistency, dest);
        encoder.writeInt(batch.flags, dest);
        if (Flags.contains(batch.flags, 16)) {
            encoder.writeUnsignedShort(batch.serialConsistency, dest);
        }
        if (Flags.contains(batch.flags, 32)) {
            encoder.writeLong(batch.defaultTimestamp, dest);
        }
        if (Flags.contains(batch.flags, 128)) {
            encoder.writeString(batch.keyspace, dest);
        }
    }

    @Override
    public int encodedSize(Message message) {
        Batch batch = (Batch)message;
        int size = 1;
        size += 2;
        int queryCount = batch.queriesOrIds.size();
        ProtocolErrors.check(queryCount <= 65535, "Batch messages can contain at most %d queries", 65535);
        ProtocolErrors.check(batch.values.size() == queryCount, "Batch contains %d queries but %d value lists", queryCount, batch.values.size());
        for (int i = 0; i < queryCount; ++i) {
            Object q = batch.queriesOrIds.get(i);
            size += 1 + (q instanceof String ? PrimitiveSizes.sizeOfLongString((String)q) : PrimitiveSizes.sizeOfShortBytes((byte[])q));
            size += Values.sizeOfPositionalValues(batch.values.get(i));
        }
        size += 6;
        if (Flags.contains(batch.flags, 16)) {
            size += 2;
        }
        if (Flags.contains(batch.flags, 32)) {
            size += 8;
        }
        if (Flags.contains(batch.flags, 128)) {
            size += PrimitiveSizes.sizeOfString(batch.keyspace);
        }
        return size;
    }

    @Override
    public <B> Message decode(B source, PrimitiveCodec<B> decoder) {
        byte type = decoder.readByte(source);
        int queryCount = decoder.readUnsignedShort(source);
        ArrayList<Object> queriesOrIds = new ArrayList<Object>();
        ArrayList<List<ByteBuffer>> values = new ArrayList<List<ByteBuffer>>();
        for (int i = 0; i < queryCount; ++i) {
            boolean isQueryString = decoder.readByte(source) == 0;
            queriesOrIds.add(isQueryString ? decoder.readLongString(source) : (Object)decoder.readShortBytes(source));
            values.add(Values.readPositionalValues(source, decoder));
        }
        int consistency = decoder.readUnsignedShort(source);
        int flags = decoder.readInt(source);
        int serialConsistency = Flags.contains(flags, 16) ? decoder.readUnsignedShort(source) : 8;
        long defaultTimestamp = Flags.contains(flags, 32) ? decoder.readLong(source) : Long.MIN_VALUE;
        String keyspace = Flags.contains(flags, 128) ? decoder.readString(source) : null;
        return new Batch(flags, type, queriesOrIds, values, consistency, serialConsistency, defaultTimestamp, keyspace, Integer.MIN_VALUE);
    }
}

