/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.TenantFeature;
import io.quarkus.oidc.TokenCustomizer;
import jakarta.inject.Named;
import jakarta.json.JsonObject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

public class TenantFeatureFinder {
    private TenantFeatureFinder() {
    }

    public static TokenCustomizer find(OidcTenantConfig oidcConfig) {
        if (oidcConfig == null) {
            return null;
        }
        ArcContainer container = Arc.container();
        if (container != null) {
            String customizerName = oidcConfig.token().customizerName().orElse(null);
            if (customizerName != null && !customizerName.isEmpty()) {
                InstanceHandle tokenCustomizer = container.instance(customizerName);
                if (tokenCustomizer.isAvailable()) {
                    return (TokenCustomizer)tokenCustomizer.get();
                }
                throw new OIDCException("Unable to find TokenCustomizer " + customizerName);
            }
            if (oidcConfig.tenantId().isPresent()) {
                final List<TokenCustomizer> tokenCustomizers = TenantFeatureFinder.find(oidcConfig, TokenCustomizer.class);
                if (tokenCustomizers.isEmpty()) {
                    return null;
                }
                if (tokenCustomizers.size() == 1) {
                    return tokenCustomizers.get(0);
                }
                return new TokenCustomizer(){

                    @Override
                    public JsonObject customizeHeaders(JsonObject headers) {
                        JsonObject result = headers;
                        for (TokenCustomizer tokenCustomizer : tokenCustomizers) {
                            JsonObject customizedHeaders = tokenCustomizer.customizeHeaders(result);
                            if (customizedHeaders == null) continue;
                            result = customizedHeaders;
                        }
                        return result == headers ? null : result;
                    }
                };
            }
        }
        return null;
    }

    public static <T> List<T> find(OidcTenantConfig oidcTenantConfig, Class<T> tenantFeatureClass) {
        ArcContainer container = Arc.container();
        if (oidcTenantConfig != null && container != null) {
            ArrayList<Object> tenantsValidators = new ArrayList<Object>();
            block0: for (InstanceHandle instance : container.listAll(tenantFeatureClass, new Annotation[0])) {
                if (!instance.isAvailable()) continue;
                block1: for (Annotation qualifier : instance.getBean().getQualifiers()) {
                    if (qualifier instanceof TenantFeature) {
                        TenantFeature tenantFeature = (TenantFeature)qualifier;
                        String thisTenantId = oidcTenantConfig.tenantId().get();
                        for (String thatTenantId : tenantFeature.value()) {
                            if (thisTenantId.equals(thatTenantId)) break block1;
                        }
                        continue block0;
                    }
                    if (!(qualifier instanceof Named)) continue;
                    continue block0;
                }
                tenantsValidators.add(instance.get());
            }
            if (!tenantsValidators.isEmpty()) {
                return List.copyOf(tenantsValidators);
            }
        }
        return List.of();
    }
}

