/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.transactional;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntityCore;
import org.apache.polaris.core.entity.PolarisGrantRecord;
import org.apache.polaris.core.entity.PolarisPrincipalSecrets;
import org.apache.polaris.core.policy.PolarisPolicyMappingRecord;

public class TreeMapMetaStore {
    private final Object lock;
    private Transaction tr;
    private final PolarisDiagnostics initialDiagnosticServices;
    private PolarisDiagnostics diagnosticServices;
    private final Slice<PolarisBaseEntity> sliceEntities;
    private final Slice<PolarisBaseEntity> sliceEntitiesActive;
    private final Slice<PolarisBaseEntity> sliceEntitiesChangeTracking;
    private final Slice<PolarisGrantRecord> sliceGrantRecords;
    private final Slice<PolarisGrantRecord> sliceGrantRecordsByGrantee;
    private final Slice<PolarisPrincipalSecrets> slicePrincipalSecrets;
    private final Slice<PolarisPolicyMappingRecord> slicePolicyMappingRecords;
    private final Slice<PolarisPolicyMappingRecord> slicePolicyMappingRecordsByPolicy;
    private final AtomicLong nextId = new AtomicLong();

    public TreeMapMetaStore(@Nonnull PolarisDiagnostics diagnostics) {
        this.sliceEntities = new Slice<PolarisBaseEntity>(entity -> String.format("%d::%d", entity.getCatalogId(), entity.getId()), entity -> new PolarisBaseEntity.Builder((PolarisBaseEntity)entity).build());
        this.sliceEntitiesActive = new Slice<PolarisBaseEntity>(this::buildEntitiesActiveKey, entity -> new PolarisBaseEntity.Builder((PolarisBaseEntity)entity).build());
        this.sliceEntitiesChangeTracking = new Slice<PolarisBaseEntity>(entity -> String.format("%d::%d", entity.getCatalogId(), entity.getId()), entity -> new PolarisBaseEntity.Builder((PolarisBaseEntity)entity).build());
        this.sliceGrantRecords = new Slice<PolarisGrantRecord>(grantRecord -> String.format("%d::%d::%d::%d::%d", grantRecord.getSecurableCatalogId(), grantRecord.getSecurableId(), grantRecord.getGranteeCatalogId(), grantRecord.getGranteeId(), grantRecord.getPrivilegeCode()), PolarisGrantRecord::new);
        this.sliceGrantRecordsByGrantee = new Slice<PolarisGrantRecord>(grantRecord -> String.format("%d::%d::%d::%d::%d", grantRecord.getGranteeCatalogId(), grantRecord.getGranteeId(), grantRecord.getSecurableCatalogId(), grantRecord.getSecurableId(), grantRecord.getPrivilegeCode()), PolarisGrantRecord::new);
        this.slicePrincipalSecrets = new Slice<PolarisPrincipalSecrets>(principalSecrets -> String.format("%s", principalSecrets.getPrincipalClientId()), PolarisPrincipalSecrets::new);
        this.slicePolicyMappingRecords = new Slice<PolarisPolicyMappingRecord>(policyMappingRecord -> String.format("%d::%d::%d::%d::%d", policyMappingRecord.getTargetCatalogId(), policyMappingRecord.getTargetId(), policyMappingRecord.getPolicyTypeCode(), policyMappingRecord.getPolicyCatalogId(), policyMappingRecord.getPolicyId()), PolarisPolicyMappingRecord::new);
        this.slicePolicyMappingRecordsByPolicy = new Slice<PolarisPolicyMappingRecord>(policyMappingRecord -> String.format("%d::%d::%d::%d::%d", policyMappingRecord.getPolicyTypeCode(), policyMappingRecord.getPolicyCatalogId(), policyMappingRecord.getPolicyId(), policyMappingRecord.getTargetCatalogId(), policyMappingRecord.getTargetId()), PolarisPolicyMappingRecord::new);
        this.initialDiagnosticServices = diagnostics;
        this.diagnosticServices = diagnostics;
        this.tr = null;
        this.lock = new Object();
    }

    String buildEntitiesActiveKey(PolarisEntityCore coreEntity) {
        return String.format("%d::%d::%d::%s", coreEntity.getCatalogId(), coreEntity.getParentId(), coreEntity.getTypeCode(), coreEntity.getName());
    }

    String buildEntitiesKey(PolarisEntityCore coreEntity) {
        return String.format("%d::%d", coreEntity.getCatalogId(), coreEntity.getId());
    }

    String buildKeyComposite(Object ... keys) {
        StringBuilder result = new StringBuilder();
        for (Object key : keys) {
            if (result.length() != 0) {
                result.append("::");
            }
            result.append(key.toString());
        }
        return result.toString();
    }

    String buildPrefixKeyComposite(Object ... keys) {
        StringBuilder result = new StringBuilder();
        for (Object key : keys) {
            result.append(key.toString());
            result.append("::");
        }
        return result.toString();
    }

    private void startReadTransaction() {
        this.diagnosticServices.check(this.tr == null, "cannot nest transaction");
        this.tr = new Transaction(false);
    }

    private void startWriteTransaction() {
        this.diagnosticServices.check(this.tr == null, "cannot nest transaction");
        this.tr = new Transaction(true);
        this.sliceEntities.startWriteTransaction();
        this.sliceEntitiesActive.startWriteTransaction();
        this.sliceEntitiesChangeTracking.startWriteTransaction();
        this.sliceGrantRecords.startWriteTransaction();
        this.sliceGrantRecordsByGrantee.startWriteTransaction();
        this.slicePrincipalSecrets.startWriteTransaction();
        this.slicePolicyMappingRecords.startWriteTransaction();
        this.slicePolicyMappingRecordsByPolicy.startWriteTransaction();
    }

    void rollback() {
        this.sliceEntities.rollback();
        this.sliceEntitiesActive.rollback();
        this.sliceEntitiesChangeTracking.rollback();
        this.sliceGrantRecords.rollback();
        this.sliceGrantRecordsByGrantee.rollback();
        this.slicePrincipalSecrets.rollback();
        this.slicePolicyMappingRecords.rollback();
        this.slicePolicyMappingRecordsByPolicy.rollback();
    }

    private void ensureReadWriteTr() {
        this.diagnosticServices.check(this.tr != null && this.tr.isWrite(), "no_write_transaction_started");
    }

    private void ensureReadTr() {
        this.diagnosticServices.checkNotNull(this.tr, "no_read_transaction_started");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T runInTransaction(@Nonnull PolarisDiagnostics diagnostics, @Nonnull Supplier<T> transactionCode) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.diagnosticServices = diagnostics;
                this.startWriteTransaction();
                T t = transactionCode.get();
                return t;
            }
            catch (Throwable e) {
                if (this.tr == null) throw e;
                this.rollback();
                throw e;
            }
            finally {
                this.tr = null;
                this.diagnosticServices = this.initialDiagnosticServices;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runActionInTransaction(@Nonnull PolarisDiagnostics diagnostics, @Nonnull Runnable transactionCode) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.diagnosticServices = diagnostics;
                this.startWriteTransaction();
                transactionCode.run();
            }
            catch (Throwable e) {
                if (this.tr != null) {
                    this.rollback();
                }
                throw e;
            }
            finally {
                this.tr = null;
                this.diagnosticServices = this.initialDiagnosticServices;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T runInReadTransaction(@Nonnull PolarisDiagnostics diagnostics, @Nonnull Supplier<T> transactionCode) {
        Object object = this.lock;
        synchronized (object) {
            this.diagnosticServices = diagnostics;
            this.startReadTransaction();
            T t = transactionCode.get();
            return t;
            finally {
                this.tr = null;
                this.diagnosticServices = this.initialDiagnosticServices;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runActionInReadTransaction(@Nonnull PolarisDiagnostics diagnostics, @Nonnull Runnable transactionCode) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.diagnosticServices = diagnostics;
                this.startReadTransaction();
                transactionCode.run();
            }
            finally {
                this.tr = null;
                this.diagnosticServices = this.initialDiagnosticServices;
            }
        }
    }

    public Slice<PolarisBaseEntity> getSliceEntities() {
        return this.sliceEntities;
    }

    public Slice<PolarisBaseEntity> getSliceEntitiesActive() {
        return this.sliceEntitiesActive;
    }

    public Slice<PolarisBaseEntity> getSliceEntitiesChangeTracking() {
        return this.sliceEntitiesChangeTracking;
    }

    public Slice<PolarisGrantRecord> getSliceGrantRecords() {
        return this.sliceGrantRecords;
    }

    public Slice<PolarisGrantRecord> getSliceGrantRecordsByGrantee() {
        return this.sliceGrantRecordsByGrantee;
    }

    public Slice<PolarisPrincipalSecrets> getSlicePrincipalSecrets() {
        return this.slicePrincipalSecrets;
    }

    public Slice<PolarisPolicyMappingRecord> getSlicePolicyMappingRecords() {
        return this.slicePolicyMappingRecords;
    }

    public Slice<PolarisPolicyMappingRecord> getSlicePolicyMappingRecordsByPolicy() {
        return this.slicePolicyMappingRecordsByPolicy;
    }

    public long getNextSequence() {
        this.ensureReadWriteTr();
        return this.nextId.incrementAndGet();
    }

    void deleteAll() {
        this.ensureReadWriteTr();
        this.sliceEntities.deleteAll();
        this.sliceEntitiesActive.deleteAll();
        this.sliceEntitiesChangeTracking.deleteAll();
        this.sliceGrantRecordsByGrantee.deleteAll();
        this.sliceGrantRecords.deleteAll();
        this.slicePrincipalSecrets.deleteAll();
        this.slicePolicyMappingRecords.deleteAll();
        this.slicePolicyMappingRecordsByPolicy.deleteAll();
    }

    public class Slice<T> {
        private final TreeMap<String, T> slice = new TreeMap();
        private final TreeMap<String, T> undoSlice = new TreeMap();
        private final Function<T, String> buildKey;
        private final Function<T, T> copyRecord;

        private Slice(Function<T, String> buildKey, Function<T, T> copyRecord) {
            this.buildKey = buildKey;
            this.copyRecord = copyRecord;
        }

        public String buildKey(T value) {
            return this.buildKey.apply(value);
        }

        public T read(String key) {
            TreeMapMetaStore.this.ensureReadTr();
            Object value = this.slice.getOrDefault(key, null);
            return value != null ? (T)this.copyRecord.apply(value) : null;
        }

        public List<T> readRange(String prefix) {
            TreeMapMetaStore.this.ensureReadTr();
            if (prefix.isEmpty()) {
                return new ArrayList<T>(this.slice.values());
            }
            String endKey = prefix.substring(0, prefix.length() - 1) + (char)(prefix.charAt(prefix.length() - 1) + '\u0001');
            return new ArrayList(this.slice.subMap(prefix, true, endKey, false).values());
        }

        public void write(T value) {
            TreeMapMetaStore.this.ensureReadWriteTr();
            Object valueToWrite = value != null ? (Object)this.copyRecord.apply(value) : null;
            String key = this.buildKey(valueToWrite);
            if (!this.undoSlice.containsKey(key)) {
                this.undoSlice.put(key, this.slice.getOrDefault(key, null));
            }
            this.slice.put(key, valueToWrite);
        }

        public void delete(String key) {
            TreeMapMetaStore.this.ensureReadWriteTr();
            if (this.slice.containsKey(key)) {
                if (!this.undoSlice.containsKey(key)) {
                    this.undoSlice.put(key, this.slice.getOrDefault(key, null));
                }
                this.slice.remove(key);
            }
        }

        public void deleteRange(String prefix) {
            TreeMapMetaStore.this.ensureReadWriteTr();
            List<T> elements = this.readRange(prefix);
            for (T element : elements) {
                this.delete(element);
            }
        }

        void deleteAll() {
            TreeMapMetaStore.this.ensureReadWriteTr();
            this.slice.clear();
            this.undoSlice.clear();
        }

        public void delete(T value) {
            this.delete(this.buildKey(value));
        }

        private void rollback() {
            TreeMapMetaStore.this.ensureReadWriteTr();
            this.undoSlice.forEach((key, value) -> {
                if (value == null) {
                    this.slice.remove(key);
                } else {
                    this.slice.put((String)key, (T)value);
                }
            });
        }

        private void startWriteTransaction() {
            this.undoSlice.clear();
        }
    }

    private static class Transaction {
        private final boolean isWrite;

        private Transaction(boolean isWrite) {
            this.isWrite = isWrite;
        }

        public boolean isWrite() {
            return this.isWrite;
        }
    }
}

