/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.persistence.relational.jdbc;

import java.io.InputStream;
import java.util.Locale;
import org.apache.polaris.persistence.relational.jdbc.DatasourceOperations;

public enum DatabaseType {
    POSTGRES("postgres"),
    H2("h2");

    private final String displayName;

    private DatabaseType(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static DatabaseType fromDisplayName(String displayName) {
        return switch (displayName.toLowerCase(Locale.ROOT)) {
            case "h2" -> H2;
            case "postgresql" -> POSTGRES;
            default -> throw new IllegalStateException("Unsupported DatabaseType: '" + displayName + "'");
        };
    }

    public InputStream openInitScriptResource(int schemaVersion) {
        if (schemaVersion <= 0 || schemaVersion > 3) {
            throw new IllegalArgumentException("Unknown or invalid schema version " + schemaVersion);
        }
        String resourceName = String.format("%s/schema-v%d.sql", this.getDisplayName(), schemaVersion);
        ClassLoader classLoader = DatasourceOperations.class.getClassLoader();
        return classLoader.getResourceAsStream(resourceName);
    }
}

