/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import java.util.Locale;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.message.HttpResponseWrapper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HttpResponseWrapperTest {
    HttpResponseWrapperTest() {
    }

    @Test
    void testDefaultResponseConstructors() {
        BasicHttpResponse response1 = new BasicHttpResponse(400, "Bad Request");
        HttpResponseWrapper httpResponseWrapper1 = new HttpResponseWrapper((HttpResponse)response1);
        Assertions.assertEquals((int)400, (int)httpResponseWrapper1.getCode());
        BasicHttpResponse response2 = new BasicHttpResponse(500, "whatever");
        HttpResponseWrapper httpResponseWrapper2 = new HttpResponseWrapper((HttpResponse)response2);
        Assertions.assertEquals((int)500, (int)httpResponseWrapper2.getCode());
        Assertions.assertEquals((Object)"whatever", (Object)httpResponseWrapper2.getReasonPhrase());
        httpResponseWrapper2.setReasonPhrase("another-whatever");
        Assertions.assertEquals((Object)"another-whatever", (Object)httpResponseWrapper2.getReasonPhrase());
    }

    @Test
    void testSetResponseStatus() {
        BasicHttpResponse response1 = new BasicHttpResponse(200, "OK");
        HttpResponseWrapper httpResponseWrapper1 = new HttpResponseWrapper((HttpResponse)response1);
        Assertions.assertEquals((int)200, (int)httpResponseWrapper1.getCode());
        BasicHttpResponse response2 = new BasicHttpResponse(400, "Bad Request");
        HttpResponseWrapper httpResponseWrapper2 = new HttpResponseWrapper((HttpResponse)response2);
        Assertions.assertEquals((int)400, (int)httpResponseWrapper2.getCode());
        BasicHttpResponse response3 = new BasicHttpResponse(500, "whatever");
        HttpResponseWrapper httpResponseWrapper3 = new HttpResponseWrapper((HttpResponse)response3);
        Assertions.assertEquals((int)500, (int)httpResponseWrapper3.getCode());
        Assertions.assertEquals((Object)"whatever", (Object)httpResponseWrapper3.getReasonPhrase());
        BasicHttpResponse response4 = new BasicHttpResponse(200, "OK");
        HttpResponseWrapper httpResponseWrapper4 = new HttpResponseWrapper((HttpResponse)response4);
        Assertions.assertThrows(IllegalArgumentException.class, () -> httpResponseWrapper4.setCode(-23));
    }

    @Test
    void testLocale() {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        HttpResponseWrapper httpResponseWrapper = new HttpResponseWrapper((HttpResponse)response);
        httpResponseWrapper.setLocale(Locale.US);
        Assertions.assertEquals((Object)"US", (Object)httpResponseWrapper.getLocale().getCountry());
    }
}

