/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors.parsers;

import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.schema.annotation.props.gen.OccursCountKind;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.runtime1.infoset.DIElement;
import org.apache.daffodil.runtime1.infoset.DINode;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.SequenceRuntimeData;
import org.apache.daffodil.runtime1.processors.Success$;
import org.apache.daffodil.runtime1.processors.parsers.ArrayIndexStatus;
import org.apache.daffodil.runtime1.processors.parsers.ArrayIndexStatus$Done$;
import org.apache.daffodil.runtime1.processors.parsers.ArrayIndexStatus$OptionalLast$;
import org.apache.daffodil.runtime1.processors.parsers.ArrayIndexStatus$OptionalMiddle$;
import org.apache.daffodil.runtime1.processors.parsers.ArrayIndexStatus$Required$;
import org.apache.daffodil.runtime1.processors.parsers.EndArrayChecksMixin;
import org.apache.daffodil.runtime1.processors.parsers.MinMaxRepeatsMixin;
import org.apache.daffodil.runtime1.processors.parsers.PState;
import org.apache.daffodil.runtime1.processors.parsers.Parser;
import org.apache.daffodil.runtime1.processors.parsers.SequenceChildParser;
import scala.deriving.Mirror;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public abstract class RepeatingChildParser
extends SequenceChildParser
implements MinMaxRepeatsMixin,
EndArrayChecksMixin {
    private OccursCountKind ock;
    private long org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$$minRepeats_;
    private long org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$$maxRepeats_;
    private boolean org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$$isBoundedMax_;
    private final ElementRuntimeData erd;
    private final String baseName;

    public RepeatingChildParser(Parser childParser, SequenceRuntimeData srd, ElementRuntimeData erd, String baseName) {
        this.erd = erd;
        this.baseName = baseName;
        super(childParser, srd, erd);
        MinMaxRepeatsMixin.$init$(this);
        Statics.releaseFence();
    }

    @Override
    public final OccursCountKind ock() {
        return this.ock;
    }

    @Override
    public long org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$$minRepeats_() {
        return this.org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$$minRepeats_;
    }

    @Override
    public long org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$$maxRepeats_() {
        return this.org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$$maxRepeats_;
    }

    @Override
    public boolean org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$$isBoundedMax_() {
        return this.org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$$isBoundedMax_;
    }

    @Override
    public void org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$_setter_$ock_$eq(OccursCountKind x$0) {
        this.ock = x$0;
    }

    @Override
    public void org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$_setter_$org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$$minRepeats__$eq(long x$0) {
        this.org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$$minRepeats_ = x$0;
    }

    @Override
    public void org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$_setter_$org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$$maxRepeats__$eq(long x$0) {
        this.org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$$maxRepeats_ = x$0;
    }

    @Override
    public void org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$_setter_$org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$$isBoundedMax__$eq(boolean x$0) {
        this.org$apache$daffodil$runtime1$processors$parsers$MinMaxRepeatsMixin$$isBoundedMax_ = x$0;
    }

    private Parser childParser$accessor() {
        return super.childParser();
    }

    private SequenceRuntimeData srd$accessor() {
        return super.srd();
    }

    @Override
    public ElementRuntimeData erd() {
        return this.erd;
    }

    @Override
    public final Object maybeStaticRequiredOptionalStatus() {
        return Maybe$.MODULE$.Nope();
    }

    public ArrayIndexStatus arrayIndexStatus(long minRepeats, long maxRepeats, PState pstate) {
        ArrayIndexStatus arrayIndexStatus;
        if (pstate.processorStatus() != Success$.MODULE$) {
            throw Assert$.MODULE$.abort("Invariant broken: pstate.processorStatus.eq(org.apache.daffodil.runtime1.processors.Success)");
        }
        long apos = pstate.arrayIterationPos();
        if (apos <= minRepeats) {
            arrayIndexStatus = ArrayIndexStatus$Required$.MODULE$;
        } else if (apos < maxRepeats) {
            arrayIndexStatus = ArrayIndexStatus$OptionalMiddle$.MODULE$;
        } else {
            Mirror.Singleton singleton;
            if (apos == maxRepeats) {
                singleton = ArrayIndexStatus$OptionalLast$.MODULE$;
            } else {
                if (apos != maxRepeats + 1L) {
                    throw Assert$.MODULE$.abort("Invariant broken: apos.==(maxRepeats.+(1))");
                }
                singleton = ArrayIndexStatus$Done$.MODULE$;
            }
            arrayIndexStatus = singleton;
        }
        ArrayIndexStatus$Required$ result = arrayIndexStatus;
        return result;
    }

    @Override
    public String toString() {
        return "Rep" + this.baseName + "(" + this.childParser$accessor().toString() + ")";
    }

    @Override
    public String toBriefXML(int depthLimit) {
        if (depthLimit == 0) {
            return "...";
        }
        return "<Rep" + this.baseName + " name='" + this.erd().name() + "'>" + this.childParser$accessor().toBriefXML(depthLimit - 1) + "</Rep" + this.baseName + ">";
    }

    @Override
    public int toBriefXML$default$1() {
        return -1;
    }

    public void startArray(PState state) {
        state.mpstate().arrayIterationIndexStack().push(BoxesRunTime.boxToLong((long)1L));
        state.mpstate().occursIndexStack().push(BoxesRunTime.boxToLong((long)1L));
    }

    public void endArray(PState state) {
        state.mpstate().arrayIterationIndexStack().pop();
        long occurrences = BoxesRunTime.unboxToLong(state.mpstate().occursIndexStack().pop()) - 1L;
        EndArrayChecksMixin.endArray$(this, state, occurrences);
        if (state.processorStatus() == Success$.MODULE$ && occurrences > 0L && this.erd().isArray()) {
            DIElement parent = state.infoset();
            Object object = parent.maybeLastChild();
            DINode array = (DINode)Maybe$.MODULE$.get$extension(object);
            array.setFinal();
            return;
        }
    }
}

