/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.descriptors;

import java.lang.reflect.Field;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.mappings.AttributeAccessor;

public class InstanceVariableAttributeAccessor
extends AttributeAccessor {
    protected transient Field attributeField;

    @Override
    public Class<?> getAttributeClass() {
        if (this.getAttributeField() == null) {
            return null;
        }
        return this.getAttributeType();
    }

    public Field getAttributeField() {
        return this.attributeField;
    }

    public Class<?> getAttributeType() {
        return this.attributeField.getType();
    }

    @Override
    public Object getAttributeValueFromObject(Object anObject) throws DescriptorException {
        return PrivilegedAccessHelper.callDoPrivilegedWithException(() -> this.attributeField.get(anObject), ex -> {
            if (ex instanceof IllegalArgumentException) {
                return DescriptorException.illegalArgumentWhileGettingValueThruInstanceVariableAccessor(this.getAttributeName(), this.getAttributeType().getName(), anObject.getClass().getName(), ex);
            }
            if (ex instanceof IllegalAccessException) {
                return DescriptorException.illegalAccesstWhileGettingValueThruInstanceVaraibleAccessor(this.getAttributeName(), anObject.getClass().getName(), ex);
            }
            if (ex instanceof NullPointerException) {
                String className = anObject != null ? anObject.getClass().getName() : null;
                return DescriptorException.nullPointerWhileGettingValueThruInstanceVariableAccessor(this.getAttributeName(), className, ex);
            }
            throw new RuntimeException(String.format("Getting value from %s field failed", this.attributeField.getName()), ex);
        });
    }

    @Override
    public void initializeAttributes(Class<?> theJavaClass) throws DescriptorException {
        if (this.getAttributeName() == null) {
            throw DescriptorException.attributeNameNotSpecified();
        }
        try {
            this.setAttributeField(Helper.getField(theJavaClass, this.getAttributeName()));
        }
        catch (NoSuchFieldException exception) {
            throw DescriptorException.noSuchFieldWhileInitializingAttributesInInstanceVariableAccessor(this.getAttributeName(), theJavaClass.getName(), exception);
        }
        catch (SecurityException exception) {
            throw DescriptorException.securityWhileInitializingAttributesInInstanceVariableAccessor(this.getAttributeName(), theJavaClass.getName(), exception);
        }
    }

    @Override
    public boolean isInitialized() {
        return this.attributeField != null;
    }

    @Override
    public boolean isInstanceVariableAttributeAccessor() {
        return true;
    }

    protected void setAttributeField(Field field) {
        this.attributeField = field;
    }

    @Override
    public void setAttributeValueInObject(Object anObject, Object value) throws DescriptorException {
        try {
            PrivilegedAccessHelper.callDoPrivilegedWithException(() -> this.attributeField.set(anObject, value));
        }
        catch (IllegalArgumentException exception) {
            if (value == null) {
                Class<?> fieldClass = this.getAttributeClass();
                if (Helper.isPrimitiveWrapper(fieldClass)) {
                    PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.setValueInField(this.attributeField, anObject, ConversionManager.getDefaultManager().convertObject(0, fieldClass)), ex -> DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), null, ex));
                }
                return;
            }
            try {
                if (value instanceof String) {
                    Object newValue = ConversionManager.getDefaultManager().convertObject(value, this.getAttributeClass());
                    PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.setValueInField(this.attributeField, anObject, newValue));
                    return;
                }
            }
            catch (Exception newValue) {
                // empty catch block
            }
            throw DescriptorException.illegalArgumentWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), this.getAttributeType().getName(), value, exception);
        }
        catch (IllegalAccessException exception) {
            if (value == null) {
                return;
            }
            throw DescriptorException.illegalAccessWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), anObject.getClass().getName(), value, exception);
        }
        catch (NullPointerException exception) {
            if (anObject != null) {
                Class<?> fieldClass = this.getAttributeClass();
                if (Helper.isPrimitiveWrapper(fieldClass) && value == null) {
                    if (Helper.isPrimitiveWrapper(fieldClass)) {
                        PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.setValueInField(this.attributeField, anObject, ConversionManager.getDefaultManager().convertObject(0, fieldClass)), ex -> DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), null, ex));
                    }
                }
                throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), value, exception);
            }
            throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), value, exception);
        }
        catch (Exception ex2) {
            throw new RuntimeException(String.format("Setting value in %s field failed", this.attributeField.getName()), ex2);
        }
    }
}

