/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.redirect;

import java.util.Optional;
import org.jasig.cas.client.Protocol;
import org.jasig.cas.client.util.CommonUtils;
import org.pac4j.cas.client.CasClient;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.config.CasProtocol;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.redirect.RedirectionActionBuilder;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpActionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasRedirectionActionBuilder
implements RedirectionActionBuilder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected CasConfiguration configuration;
    protected CasClient client;

    public CasRedirectionActionBuilder(CasConfiguration configuration, CasClient client) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)configuration));
        CommonHelper.assertNotNull((String)"client", (Object)((Object)client));
        this.configuration = configuration;
        this.client = client;
    }

    public Optional<RedirectionAction> getRedirectionAction(WebContext context, SessionStore sessionStore) {
        String computeLoginUrl = this.configuration.computeFinalLoginUrl(context);
        String computedCallbackUrl = this.client.computeFinalCallbackUrl(context);
        boolean renew = this.configuration.isRenew() || context.getRequestAttribute("ForceAuthn").isPresent();
        boolean gateway = this.configuration.isGateway() || context.getRequestAttribute("Passive").isPresent();
        String redirectionUrl = CommonUtils.constructRedirectUrl((String)computeLoginUrl, (String)this.getServiceParameter(), (String)computedCallbackUrl, (boolean)renew, (boolean)gateway, (String)this.configuration.getMethod());
        this.logger.debug("redirectionUrl: {}", (Object)redirectionUrl);
        return Optional.of(HttpActionHelper.buildRedirectUrlAction((WebContext)context, (String)redirectionUrl));
    }

    protected String getServiceParameter() {
        if (this.configuration.getProtocol() == CasProtocol.SAML) {
            return Protocol.SAML11.getServiceParameterName();
        }
        return "service";
    }
}

