/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.function.Supplier;
import org.apereo.cas.api.PrincipalProvisioner;
import org.apereo.cas.authentication.principal.provision.DelegatedClientUserProfileProvisioner;
import org.apereo.cas.authentication.principal.provision.GroovyDelegatedClientUserProfileProvisioner;
import org.apereo.cas.authentication.principal.provision.RestfulDelegatedClientUserProfileProvisioner;
import org.apereo.cas.authentication.principal.provision.ScimDelegatedClientUserProfileProvisioner;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.RestEndpointProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationProvisioningProperties;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.Resource;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.DelegatedAuthentication)
@AutoConfiguration
public class Pac4jAuthenticationProvisioningConfiguration {

    @Configuration(value="Pac4jAuthenticationEventExecutionPlanProvisionerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class Pac4jAuthenticationEventExecutionPlanProvisionerConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"groovyDelegatedClientUserProfileProvisioner"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Supplier<DelegatedClientUserProfileProvisioner> groovyDelegatedClientUserProfileProvisioner(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (Supplier)BeanSupplier.of(Supplier.class).when(BeanCondition.on((String)"cas.authn.pac4j.provisioning.groovy.location").exists().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                Pac4jDelegatedAuthenticationProvisioningProperties provisioning = casProperties.getAuthn().getPac4j().getProvisioning();
                Resource script = provisioning.getGroovy().getLocation();
                return () -> new GroovyDelegatedClientUserProfileProvisioner(script);
            }).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"restDelegatedClientUserProfileProvisioner"})
        public Supplier<DelegatedClientUserProfileProvisioner> restDelegatedClientUserProfileProvisioner(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) throws Exception {
            return (Supplier)BeanSupplier.of(Supplier.class).when(BeanCondition.on((String)"cas.authn.pac4j.provisioning.rest.url").isUrl().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                Pac4jDelegatedAuthenticationProvisioningProperties provisioning = casProperties.getAuthn().getPac4j().getProvisioning();
                return () -> new RestfulDelegatedClientUserProfileProvisioner((RestEndpointProperties)provisioning.getRest());
            }).otherwiseProxy().get();
        }
    }

    @Configuration(value="Pac4jAuthenticationScimProvisioningConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnClass(value={PrincipalProvisioner.class})
    public static class Pac4jAuthenticationScimProvisioningConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"pac4jScimDelegatedClientUserProfileProvisioner"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Supplier<DelegatedClientUserProfileProvisioner> pac4jScimDelegatedClientUserProfileProvisioner(ConfigurableApplicationContext applicationContext, @Qualifier(value="scimProvisioner") PrincipalProvisioner scimProvisioner) {
            return (Supplier)BeanSupplier.of(Supplier.class).when(BeanCondition.on((String)"cas.authn.pac4j.provisioning.scim.enabled").isTrue().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> () -> new ScimDelegatedClientUserProfileProvisioner(scimProvisioner)).otherwiseProxy().get();
        }
    }
}

