/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.cmd;

import net.tirasa.connid.bundles.cmd.search.Operand;
import net.tirasa.connid.bundles.cmd.search.Operator;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.filter.AbstractFilterTranslator;
import org.identityconnectors.framework.common.objects.filter.ContainsFilter;
import org.identityconnectors.framework.common.objects.filter.EndsWithFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsIgnoreCaseFilter;
import org.identityconnectors.framework.common.objects.filter.StartsWithFilter;
import org.identityconnectors.framework.common.objects.filter.StringFilter;

public class CmdFilterTranslator
extends AbstractFilterTranslator<Operand> {
    protected Operand createEqualsIgnoreCaseExpression(EqualsIgnoreCaseFilter filter, boolean not) {
        return this.createOperand(Operator.EQ, (StringFilter)filter, not);
    }

    protected Operand createStartsWithExpression(StartsWithFilter filter, boolean not) {
        return this.createOperand(Operator.SW, (StringFilter)filter, not);
    }

    protected Operand createEndsWithExpression(EndsWithFilter filter, boolean not) {
        return this.createOperand(Operator.EW, (StringFilter)filter, not);
    }

    protected Operand createContainsExpression(ContainsFilter filter, boolean not) {
        return this.createOperand(Operator.C, (StringFilter)filter, not);
    }

    protected Operand createEqualsExpression(EqualsFilter filter, boolean not) {
        if (filter == null) {
            return null;
        }
        String value = AttributeUtil.getAsStringValue((Attribute)filter.getAttribute());
        if (StringUtil.isBlank((String)value)) {
            return null;
        }
        return new Operand(Operator.EQ, filter.getAttribute().getName(), value, not);
    }

    private Operand createOperand(Operator op, StringFilter filter, boolean not) {
        if (filter == null) {
            return null;
        }
        String value = AttributeUtil.getAsStringValue((Attribute)filter.getAttribute());
        if (StringUtil.isBlank((String)value)) {
            return null;
        }
        switch (op) {
            case EQ: {
                return new Operand(Operator.EQ, filter.getAttribute().getName(), value, not);
            }
            case SW: {
                return new Operand(Operator.SW, filter.getAttribute().getName(), value.substring(0, value.length() - 1), not);
            }
            case EW: {
                return new Operand(Operator.EW, filter.getAttribute().getName(), value.substring(1), not);
            }
            case C: {
                return new Operand(Operator.C, filter.getAttribute().getName(), value.substring(1, value.length() - 1), not);
            }
        }
        return null;
    }
}

