/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.batch;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class BatchItemResponse
implements HttpServletResponse {
    private final Set<Cookie> cookies = new HashSet<Cookie>();
    private final Map<String, List<Object>> headers = new HashMap<String, List<Object>>();
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private final ServletOutputStream servletOuputStream = new ServletOutputStream(){

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
        }

        public void write(int b) throws IOException {
            BatchItemResponse.this.baos.write(b);
        }
    };
    private final PrintWriter writer = new PrintWriter(this.baos);
    private int status;
    private Locale locale;

    public Set<Cookie> getCookies() {
        return this.cookies;
    }

    public Map<String, List<Object>> getHeaders() {
        return this.headers;
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    public void setDateHeader(String name, long date) {
        List<Object> values = this.headers.get(name);
        if (values == null) {
            values = new ArrayList<Object>();
            this.headers.put(name, values);
        } else {
            values.clear();
        }
        values.add(date);
    }

    public void addDateHeader(String name, long date) {
        List<Object> values = this.headers.get(name);
        if (values == null) {
            values = new ArrayList<Object>();
            this.headers.put(name, values);
        }
        values.add(date);
    }

    public void setHeader(String name, String value) {
        List<Object> values = this.headers.get(name);
        if (values == null) {
            values = new ArrayList<Object>();
            this.headers.put(name, values);
        } else {
            values.clear();
        }
        values.add(value);
    }

    public void addHeader(String name, String value) {
        List<Object> values = this.headers.get(name);
        if (values == null) {
            values = new ArrayList<Object>();
            this.headers.put(name, values);
        }
        values.add(value);
    }

    public void setIntHeader(String name, int value) {
        List<Object> values = this.headers.get(name);
        if (values == null) {
            values = new ArrayList<Object>();
            this.headers.put(name, values);
        } else {
            values.clear();
        }
        values.add(value);
    }

    public void addIntHeader(String name, int value) {
        List<Object> values = this.headers.get(name);
        if (values == null) {
            values = new ArrayList<Object>();
            this.headers.put(name, values);
        }
        values.add(value);
    }

    public String getHeader(String name) {
        return this.headers.containsKey(name) ? this.headers.get(name).get(0).toString() : null;
    }

    public Collection<String> getHeaders(String name) {
        return this.headers.containsKey(name) ? (Collection)this.headers.get(name).stream().map(Object::toString).collect(Collectors.toList()) : List.of();
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public void sendError(int sc, String msg) throws IOException {
        this.setStatus(sc);
    }

    public void sendError(int sc) throws IOException {
        this.setStatus(sc);
    }

    public void sendRedirect(String location) throws IOException {
        this.setStatus(302);
        this.setHeader("Location", location);
    }

    public void setStatus(int sc) {
        this.status = sc;
    }

    public void setStatus(int sc, String sm) {
        this.setStatus(sc);
    }

    public int getStatus() {
        return this.status;
    }

    public String getCharacterEncoding() {
        throw new UnsupportedOperationException();
    }

    public String getContentType() {
        throw new UnsupportedOperationException();
    }

    public ByteArrayOutputStream getUnderlyingOutputStream() {
        return this.baos;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.servletOuputStream;
    }

    public PrintWriter getWriter() throws IOException {
        return this.writer;
    }

    public void setCharacterEncoding(String charset) {
        throw new UnsupportedOperationException();
    }

    public void setContentLength(int len) {
        this.setIntHeader("Content-Length", len);
    }

    public void setContentLengthLong(long len) {
        this.setContentLength((int)len);
    }

    public void setContentType(String type) {
        this.setHeader("Content-Type", type);
    }

    public void setBufferSize(int size) {
        throw new UnsupportedOperationException();
    }

    public int getBufferSize() {
        throw new UnsupportedOperationException();
    }

    public void flushBuffer() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void resetBuffer() {
        throw new UnsupportedOperationException();
    }

    public boolean isCommitted() {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

