/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.mfa.simple.ticket.CasSimpleMultifactorAuthenticationTicket;
import org.apereo.cas.mfa.simple.ticket.CasSimpleMultifactorAuthenticationTicketImpl;
import org.apereo.cas.ticket.BaseTicketCatalogConfigurer;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketCatalogConfigurer;
import org.apereo.cas.ticket.TicketDefinition;
import org.apereo.cas.ticket.TicketDefinitionProperties;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.SimpleMFA)
@AutoConfiguration
public class CasSimpleMultifactorAuthenticationTicketCatalogConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasSimpleMultifactorAuthenticationTicketCatalogConfiguration.class);

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public TicketCatalogConfigurer casSimpleMultifactorAuthenticationTicketCatalogConfigurer(final @Qualifier(value="casSimpleMultifactorAuthenticationTicketExpirationPolicy") ExpirationPolicyBuilder casSimpleMultifactorAuthenticationTicketExpirationPolicy) {
        return new BaseTicketCatalogConfigurer(){

            public void configureTicketCatalog(TicketCatalog plan, CasConfigurationProperties casProperties) {
                LOGGER.trace("Registering ticket definitions...");
                TicketDefinition definition = this.buildTicketDefinition(plan, "CASMFA", CasSimpleMultifactorAuthenticationTicket.class, CasSimpleMultifactorAuthenticationTicketImpl.class, Integer.MIN_VALUE);
                TicketDefinitionProperties properties = definition.getProperties();
                properties.setStorageName("casSimpleMultifactorAuthenticationTicketsCache");
                Long timeToLive = casSimpleMultifactorAuthenticationTicketExpirationPolicy.buildTicketExpirationPolicy().getTimeToLive();
                properties.setStorageTimeout(timeToLive.longValue());
                this.registerTicketDefinition(plan, definition);
            }
        };
    }
}

