/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.runnel.encoding.dataholders;

import java.util.List;
import org.terracotta.runnel.encoding.dataholders.AbstractDataHolder;
import org.terracotta.runnel.encoding.dataholders.DataHolder;
import org.terracotta.runnel.utils.VLQ;
import org.terracotta.runnel.utils.WriteBuffer;

public class ArrayDataHolder
extends AbstractDataHolder {
    private final List<? extends DataHolder> values;
    private int cacheSize = -1;

    public ArrayDataHolder(List<? extends DataHolder> values, int index) {
        super(index);
        this.values = values;
    }

    @Override
    protected int valueSize() {
        if (this.cacheSize < 0) {
            int size = 0;
            for (DataHolder dataHolder : this.values) {
                size += dataHolder.size(false);
            }
            this.cacheSize = size += VLQ.encodedSize(this.values.size());
        }
        return this.cacheSize;
    }

    @Override
    protected void encodeValue(WriteBuffer writeBuffer) {
        writeBuffer.putVlqInt(this.values.size());
        for (DataHolder dataHolder : this.values) {
            dataHolder.encode(writeBuffer, false);
        }
    }
}

