/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.UserVariable;
import liquibase.repackaged.net.sf.jsqlparser.statement.DeclareStatement$TypeDefExpr;
import liquibase.repackaged.net.sf.jsqlparser.statement.DeclareType;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.ColDataType;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.ColumnDefinition;

public final class DeclareStatement
implements Statement {
    private UserVariable userVariable = null;
    private DeclareType declareType = DeclareType.TYPE;
    private String typeName;
    private List<DeclareStatement$TypeDefExpr> typeDefExprList = new ArrayList<DeclareStatement$TypeDefExpr>();
    private List<ColumnDefinition> columnDefinitions = new ArrayList<ColumnDefinition>();

    public final void setUserVariable(UserVariable userVariable) {
        this.userVariable = userVariable;
    }

    public final UserVariable getUserVariable() {
        return this.userVariable;
    }

    @Deprecated
    public final DeclareType getType() {
        return this.getDeclareType();
    }

    public final DeclareType getDeclareType() {
        return this.declareType;
    }

    public final String getTypeName() {
        return this.typeName;
    }

    public final void setDeclareType(DeclareType declareType) {
        this.declareType = declareType;
    }

    public final void addType(ColDataType colDataType, Expression expression) {
        this.addTypeDefExprList(new DeclareStatement$TypeDefExpr(colDataType, expression));
    }

    public final void addType(UserVariable userVariable, ColDataType colDataType, Expression expression) {
        this.addTypeDefExprList(new DeclareStatement$TypeDefExpr(userVariable, colDataType, expression));
    }

    public final DeclareStatement addTypeDefExprList(DeclareStatement$TypeDefExpr ... declareStatement$TypeDefExprArray) {
        List list = Optional.ofNullable(this.getTypeDefExprList()).orElseGet(ArrayList::new);
        Collections.addAll(list, declareStatement$TypeDefExprArray);
        return this.withTypeDefExprList(list);
    }

    public final DeclareStatement addTypeDefExprList(Collection<? extends DeclareStatement$TypeDefExpr> collection) {
        List list = Optional.ofNullable(this.getTypeDefExprList()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withTypeDefExprList(list);
    }

    public final DeclareStatement withTypeDefExprList(List<DeclareStatement$TypeDefExpr> list) {
        this.setTypeDefExprList(list);
        return this;
    }

    public final void setTypeDefExprList(List<DeclareStatement$TypeDefExpr> list) {
        this.typeDefExprList = list;
    }

    public final List<DeclareStatement$TypeDefExpr> getTypeDefExprList() {
        return this.typeDefExprList;
    }

    public final void addColumnDefinition(ColumnDefinition columnDefinition) {
        this.columnDefinitions.add(columnDefinition);
    }

    public final void setColumnDefinitions(List<ColumnDefinition> list) {
        this.columnDefinitions = list;
    }

    public final List<ColumnDefinition> getColumnDefinitions() {
        return this.columnDefinitions;
    }

    public final List<DeclareStatement$TypeDefExpr> getTypeDefinitions() {
        return this.typeDefExprList;
    }

    public final void setTypeName(String string) {
        this.typeName = string;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("DECLARE ");
        if (this.declareType == DeclareType.AS) {
            stringBuilder.append(this.userVariable.toString());
            stringBuilder.append(" AS ").append(this.typeName);
        } else if (this.declareType == DeclareType.TABLE) {
            stringBuilder.append(this.userVariable.toString());
            stringBuilder.append(" TABLE (");
            for (int i2 = 0; i2 < this.columnDefinitions.size(); ++i2) {
                if (i2 > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.columnDefinitions.get(i2).toString());
            }
            stringBuilder.append(")");
        } else {
            for (int i3 = 0; i3 < this.typeDefExprList.size(); ++i3) {
                if (i3 > 0) {
                    stringBuilder.append(", ");
                }
                DeclareStatement$TypeDefExpr declareStatement$TypeDefExpr = this.typeDefExprList.get(i3);
                if (declareStatement$TypeDefExpr.userVariable != null) {
                    stringBuilder.append(declareStatement$TypeDefExpr.userVariable.toString()).append(" ");
                }
                stringBuilder.append(declareStatement$TypeDefExpr.colDataType.toString());
                if (declareStatement$TypeDefExpr.defaultExpr == null) continue;
                stringBuilder.append(" = ").append(declareStatement$TypeDefExpr.defaultExpr.toString());
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public final void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public final DeclareStatement withUserVariable(UserVariable userVariable) {
        this.setUserVariable(userVariable);
        return this;
    }

    public final DeclareStatement withTypeName(String string) {
        this.setTypeName(string);
        return this;
    }

    public final DeclareStatement withDeclareType(DeclareType declareType) {
        this.setDeclareType(declareType);
        return this;
    }

    public final DeclareStatement withColumnDefinitions(List<ColumnDefinition> list) {
        this.setColumnDefinitions(list);
        return this;
    }

    public final DeclareStatement addColumnDefinitions(ColumnDefinition ... columnDefinitionArray) {
        List list = Optional.ofNullable(this.getColumnDefinitions()).orElseGet(ArrayList::new);
        Collections.addAll(list, columnDefinitionArray);
        return this.withColumnDefinitions(list);
    }

    public final DeclareStatement addColumnDefinitions(Collection<? extends ColumnDefinition> collection) {
        List list = Optional.ofNullable(this.getColumnDefinitions()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withColumnDefinitions(list);
    }
}

