/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.interceptor;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.aop.support.AopUtils;
import org.springmodules.cache.CacheAttribute;

public class MetadataCacheAttributeSource {
    public static final Object NULL_ATTRIBUTE = new Object();
    private final Map attributeMap = new HashMap();
    private final MetadataFinder finder;

    public MetadataCacheAttributeSource(MetadataFinder f) {
        this.finder = f;
    }

    public CacheAttribute attribute(Method m, Class t) {
        String key = this.key(m, t);
        Object cached = this.attributeMap.get(key);
        if (cached != null) {
            return this.unmaskNull(cached);
        }
        CacheAttribute attribute = this.retrieve(m, t);
        this.attributeMap.put(key, this.maskNull(attribute));
        return attribute;
    }

    private String key(Method m, Class t) {
        return t.toString() + System.identityHashCode(m);
    }

    private Object maskNull(CacheAttribute c) {
        return c == null ? NULL_ATTRIBUTE : c;
    }

    private CacheAttribute retrieve(Method m, Class t) {
        Method specificMethod = AopUtils.getMostSpecificMethod((Method)m, (Class)t);
        CacheAttribute attribute = this.finder.find(specificMethod);
        if (attribute != null) {
            return attribute;
        }
        if (specificMethod != m) {
            return this.finder.find(m);
        }
        return null;
    }

    private CacheAttribute unmaskNull(Object o) {
        return o == NULL_ATTRIBUTE ? null : (CacheAttribute)o;
    }

    public static interface MetadataFinder {
        public CacheAttribute find(Method var1);
    }
}

