/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.fileinput;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.fileinput.BootstrapFileInputField;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.fileinput.FileInputConfig;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;

public class BootstrapFileInput
extends GenericPanel<List<FileUpload>> {
    private static final long serialVersionUID = 1L;
    private final FileInputConfig config;
    private BootstrapFileInputField fileInput;

    public BootstrapFileInput(String id) {
        this(id, null);
    }

    public BootstrapFileInput(String id, IModel<List<FileUpload>> model) {
        this(id, model, new FileInputConfig());
    }

    public BootstrapFileInput(String id, IModel<List<FileUpload>> model, FileInputConfig config) {
        super(id, model);
        this.config = config;
        this.setRenderBodyOnly(true);
    }

    protected void onInitialize() {
        super.onInitialize();
        Form form = new Form("fileInputForm");
        this.add(new Component[]{form});
        this.fileInput = this.newBootstrapFileInputField("fileInput", (IModel<List<FileUpload>>)this.getModel(), this.config);
        this.fileInput.setForm(form);
        form.add(new Component[]{this.fileInput});
    }

    private BootstrapFileInputField newBootstrapFileInputField(String id, IModel<List<FileUpload>> model, FileInputConfig config) {
        return new BootstrapFileInputField(id, model, config){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onSubmit(AjaxRequestTarget target) {
                BootstrapFileInput.this.onSubmit(target);
            }

            @Override
            protected void onError(AjaxRequestTarget target) {
                BootstrapFileInput.this.onError(target);
            }
        };
    }

    protected void onSubmit(AjaxRequestTarget target) {
    }

    protected void onError(AjaxRequestTarget target) {
    }

    public boolean isShowCaption() {
        return this.config.showCaption();
    }

    public BootstrapFileInput withShowCaption(boolean showCaption) {
        this.config.showCaption(showCaption);
        return this;
    }

    public boolean isShowPreview() {
        return this.config.showPreview();
    }

    public BootstrapFileInput withShowPreview(boolean showPreview) {
        this.config.showPreview(showPreview);
        return this;
    }

    public boolean isShowRemove() {
        return this.config.showRemove();
    }

    public BootstrapFileInput withShowRemove(boolean showRemove) {
        this.config.showRemove(showRemove);
        return this;
    }

    public boolean isShowUpload() {
        return this.config.showUpload();
    }

    public BootstrapFileInput withShowUpload(boolean showUpload) {
        this.config.showUpload(showUpload);
        return this;
    }

    public FileInputConfig getConfig() {
        return this.config;
    }
}

