/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.ValidationCycle;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.AssertURL;
import net.sf.oval.internal.Log;

public class AssertURLCheck
extends AbstractAnnotationCheck<AssertURL> {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = Log.getLog(AssertURLCheck.class);
    private boolean connect = false;
    private final List<URIScheme> permittedURISchemes = Validator.getCollectionFactory().createList();

    private static boolean canConnect(String url) {
        block3: {
            int rc;
            block4: {
                try {
                    URL theURL = new URL(url);
                    URLConnection conn = theURL.openConnection();
                    conn.connect();
                    conn.getInputStream().close();
                    if (!(conn instanceof HttpURLConnection)) break block3;
                    HttpURLConnection httpConnection = (HttpURLConnection)conn;
                    rc = httpConnection.getResponseCode();
                    if (rc >= 400) break block4;
                    return true;
                }
                catch (IOException ex) {
                    LOG.debug("Connecting failed with exception", ex);
                    return false;
                }
            }
            LOG.debug("Connecting failed with HTTP response code " + rc);
            return false;
        }
        return true;
    }

    @Override
    public void configure(AssertURL constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setConnect(constraintAnnotation.connect());
        this.setPermittedURISchemes(constraintAnnotation.permittedURISchemes());
    }

    @Override
    protected ConstraintTarget[] getAppliesToDefault() {
        return new ConstraintTarget[]{ConstraintTarget.VALUES};
    }

    public URIScheme[] getPermittedURISchemes() {
        return this.permittedURISchemes.isEmpty() ? null : this.permittedURISchemes.toArray(new URIScheme[this.permittedURISchemes.size()]);
    }

    public boolean isConnect() {
        return this.connect;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, ValidationCycle cycle) {
        if (valueToValidate == null) {
            return true;
        }
        String uriString = valueToValidate.toString();
        try {
            URIScheme permittedURIScheme;
            URI uri = new URI(uriString);
            String scheme = uri.getScheme();
            if (scheme == null || uri.getRawSchemeSpecificPart() == null) {
                LOG.debug("URI scheme or scheme-specific-part not specified");
                return false;
            }
            Iterator<URIScheme> iterator = this.permittedURISchemes.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(permittedURIScheme = iterator.next()).scheme.equalsIgnoreCase(scheme));
            if (this.connect) {
                return AssertURLCheck.canConnect(uriString);
            }
            return true;
        }
        catch (URISyntaxException ex) {
            LOG.debug("URI scheme or scheme-specific-part not specified", ex);
            return false;
        }
    }

    public void setConnect(boolean connect) {
        this.connect = connect;
    }

    public void setPermittedURISchemes(URIScheme ... permittedURISchemes) {
        this.permittedURISchemes.clear();
        if (permittedURISchemes != null) {
            Collections.addAll(this.permittedURISchemes, permittedURISchemes);
        }
    }

    public void setPermittedURISchemes(List<URIScheme> permittedURISchemes) {
        this.permittedURISchemes.clear();
        if (permittedURISchemes != null) {
            this.permittedURISchemes.addAll(permittedURISchemes);
        }
    }

    public static enum URIScheme {
        FTP("ftp"),
        HTTP("http"),
        HTTPS("https");

        private final String scheme;

        private URIScheme(String scheme) {
            this.scheme = scheme;
        }

        public String getScheme() {
            return this.scheme;
        }

        public String toString() {
            return this.scheme;
        }
    }
}

