/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.BundleType;
import com.google.gxp.compiler.base.DefaultingTypeVisitor;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.base.ObjectConstant;
import com.google.gxp.compiler.base.SerializableAbstractNode;
import com.google.gxp.compiler.base.SpaceOperatorSet;
import com.google.gxp.compiler.base.Type;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;

public class FormalParameter
extends SerializableAbstractNode {
    private final String primaryName;
    private final boolean consumesContent;
    private final Type type;
    private final boolean hasDefault;
    private final Pattern regex;
    private final boolean hasConstructor;
    private final SpaceOperatorSet spaceOperators;

    public FormalParameter(SourcePosition sourcePosition, String displayName, String primaryName, boolean consumesContent, Type type, Expression defaultValue, boolean hasDefaultFlag, Pattern regex, Expression constructor, boolean hasConstructorFlag, SpaceOperatorSet spaceOperators) {
        super(sourcePosition, displayName);
        this.primaryName = Preconditions.checkNotNull(primaryName);
        this.consumesContent = consumesContent;
        this.type = Preconditions.checkNotNull(type);
        this.hasDefault = defaultValue != null || hasDefaultFlag;
        this.regex = regex;
        this.hasConstructor = constructor != null || hasConstructorFlag;
        this.spaceOperators = Preconditions.checkNotNull(spaceOperators);
    }

    public FormalParameter(Node fromNode, String primaryName, boolean consumesContent, Type type, Expression defaultValue, boolean hasDefaultFlag, Pattern regex, Expression constructor, boolean hasConstructorFlag, SpaceOperatorSet spaceOperators) {
        this(fromNode.getSourcePosition(), fromNode.getDisplayName(), primaryName, consumesContent, type, defaultValue, hasDefaultFlag, regex, constructor, hasConstructorFlag, spaceOperators);
    }

    public FormalParameter(SourcePosition sourcePosition, String displayName, String primaryName, Type type) {
        this(sourcePosition, displayName, primaryName, false, type, null, false, null, null, false, SpaceOperatorSet.NULL);
    }

    public String getPrimaryName() {
        return this.primaryName;
    }

    public Set<String> getNames() {
        return this.getType().acceptTypeVisitor(new DefaultingTypeVisitor<Set<String>>(){

            @Override
            public Set<String> defaultVisitType(Type type) {
                return Collections.singleton(FormalParameter.this.getPrimaryName());
            }

            @Override
            public Set<String> visitBundleType(BundleType type) {
                return type.getAttrMap().keySet();
            }
        });
    }

    public boolean consumesContent() {
        return this.consumesContent;
    }

    public Type getType() {
        return this.type;
    }

    public boolean hasDefault() {
        return this.hasDefault || this.type.getDefaultValue() != null;
    }

    public Pattern getRegex() {
        return this.regex;
    }

    public boolean regexMatches(ObjectConstant oc) {
        return this.regex == null ? true : this.regex.matcher(oc.getValue()).matches();
    }

    public boolean hasConstructor() {
        return this.hasConstructor;
    }

    public SpaceOperatorSet getSpaceOperators() {
        return this.spaceOperators;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof FormalParameter && this.equals((FormalParameter)that);
    }

    public boolean equals(FormalParameter that) {
        return this.equalsAbstractNode(that) && Objects.equal(this.getPrimaryName(), that.getPrimaryName()) && Objects.equal(this.getType(), that.getType()) && Objects.equal(this.hasDefault(), that.hasDefault()) && Objects.equal(this.getRegex(), that.getRegex()) && Objects.equal(this.hasConstructor(), that.hasConstructor()) && Objects.equal(this.getSpaceOperators(), that.getSpaceOperators());
    }

    public int hashCode() {
        return Objects.hashCode(this.abstractNodeHashCode(), this.getPrimaryName(), this.getType(), this.hasDefault(), this.getRegex(), this.hasConstructor(), this.getSpaceOperators());
    }
}

