/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.commons.collections4.functors;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.storm.shade.org.apache.commons.collections4.Closure;
import org.apache.storm.shade.org.apache.commons.collections4.Predicate;
import org.apache.storm.shade.org.apache.commons.collections4.functors.FunctorUtils;
import org.apache.storm.shade.org.apache.commons.collections4.functors.NOPClosure;

public class SwitchClosure<T>
implements Closure<T>,
Serializable {
    private static final long serialVersionUID = 3518477308466486130L;
    private final Predicate<? super T>[] iPredicates;
    private final Closure<? super T>[] iClosures;
    private final Closure<? super T> iDefault;

    public static <E> Closure<E> switchClosure(Map<Predicate<E>, Closure<E>> predicatesAndClosures) {
        Objects.requireNonNull(predicatesAndClosures, "predicatesAndClosures");
        Closure<E> defaultClosure = predicatesAndClosures.remove(null);
        int size = predicatesAndClosures.size();
        if (size == 0) {
            return defaultClosure == null ? NOPClosure.nopClosure() : defaultClosure;
        }
        Closure[] closures = new Closure[size];
        Predicate[] preds = new Predicate[size];
        int i = 0;
        for (Map.Entry<Predicate<E>, Closure<E>> entry : predicatesAndClosures.entrySet()) {
            preds[i] = entry.getKey();
            closures[i] = entry.getValue();
            ++i;
        }
        return new SwitchClosure<E>(false, preds, closures, defaultClosure);
    }

    public static <E> Closure<E> switchClosure(Predicate<? super E>[] predicates, Closure<? super E>[] closures, Closure<? super E> defaultClosure) {
        FunctorUtils.validate(predicates);
        FunctorUtils.validate(closures);
        if (predicates.length != closures.length) {
            throw new IllegalArgumentException("The predicate and closure arrays must be the same size");
        }
        if (predicates.length == 0) {
            return defaultClosure == null ? NOPClosure.nopClosure() : defaultClosure;
        }
        return new SwitchClosure<E>(predicates, closures, defaultClosure);
    }

    private SwitchClosure(boolean clone, Predicate<? super T>[] predicates, Closure<? super T>[] closures, Closure<? super T> defaultClosure) {
        this.iPredicates = clone ? (Predicate[])FunctorUtils.copy((java.util.function.Predicate[])predicates) : predicates;
        this.iClosures = clone ? (Closure[])FunctorUtils.copy((Consumer[])closures) : closures;
        this.iDefault = defaultClosure == null ? NOPClosure.nopClosure() : defaultClosure;
    }

    public SwitchClosure(Predicate<? super T>[] predicates, Closure<? super T>[] closures, Closure<? super T> defaultClosure) {
        this(true, predicates, closures, defaultClosure);
    }

    @Override
    public void execute(T input) {
        for (int i = 0; i < this.iPredicates.length; ++i) {
            if (!this.iPredicates[i].test(input)) continue;
            this.iClosures[i].accept(input);
            return;
        }
        this.iDefault.accept(input);
    }

    public Closure<? super T>[] getClosures() {
        return (Closure[])FunctorUtils.copy((Consumer[])this.iClosures);
    }

    public Closure<? super T> getDefaultClosure() {
        return this.iDefault;
    }

    public Predicate<? super T>[] getPredicates() {
        return (Predicate[])FunctorUtils.copy((java.util.function.Predicate[])this.iPredicates);
    }
}

