/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ConfigurationMetadata
extends JsonFormatVisitorWrapper.Base {
    private static final int MAX_DEPTH = 10;
    private final ObjectMapper mapper;
    final Map<String, JavaType> fields = new HashMap<String, JavaType>();
    private final Set<BeanProperty> parentProps = new HashSet<BeanProperty>();
    private String currentPrefix = "";
    private int currentDepth = 0;

    public ConfigurationMetadata(ObjectMapper mapper, Class<?> klass) {
        this.mapper = mapper;
        try {
            mapper.acceptJsonFormatVisitor(klass, (JsonFormatVisitorWrapper)this);
        }
        catch (JsonMappingException jsonMappingException) {
            // empty catch block
        }
    }

    private Optional<JavaType> getTypeOfField(String fieldName) {
        return Optional.ofNullable(this.fields.get(fieldName.replaceAll("\\[\\d+]", "[*]")));
    }

    public boolean isCollectionOfStrings(String fieldName) {
        Optional<JavaType> propertyType = this.getTypeOfField(fieldName);
        if (propertyType.isEmpty()) {
            return false;
        }
        if (!propertyType.get().isCollectionLikeType() && !propertyType.get().isArrayType()) {
            return false;
        }
        return propertyType.get().getContentType().isTypeOrSubTypeOf(String.class);
    }

    public JsonObjectFormatVisitor expectObjectFormat(JavaType type) throws JsonMappingException {
        final ConfigurationMetadata thiss = this;
        return new JsonObjectFormatVisitor.Base(){

            public void optionalProperty(BeanProperty prop) throws JsonMappingException {
                TypeDeserializer typeDeserializer;
                if (ConfigurationMetadata.this.currentDepth >= 10) {
                    return;
                }
                if (ConfigurationMetadata.this.parentProps.contains(prop)) {
                    return;
                }
                if (prop.getAnnotation(JsonIgnore.class) != null) {
                    return;
                }
                String name = !ConfigurationMetadata.this.currentPrefix.isEmpty() ? ConfigurationMetadata.this.currentPrefix + "." + prop.getName() : prop.getName();
                int oldFieldSize = ConfigurationMetadata.this.fields.size();
                String oldPrefix = ConfigurationMetadata.this.currentPrefix;
                ConfigurationMetadata.this.currentPrefix = name;
                ++ConfigurationMetadata.this.currentDepth;
                JavaType fieldType = prop.getType();
                if (fieldType.isCollectionLikeType() || fieldType.isArrayType()) {
                    fieldType = fieldType.getContentType();
                    ConfigurationMetadata.this.currentPrefix = ConfigurationMetadata.this.currentPrefix + "[*]";
                }
                Class defaultImpl = (typeDeserializer = ConfigurationMetadata.this.mapper.getDeserializationConfig().findTypeDeserializer(fieldType)) != null ? typeDeserializer.getDefaultImpl() : null;
                ConfigurationMetadata.this.parentProps.add(prop);
                try {
                    ConfigurationMetadata.this.mapper.acceptJsonFormatVisitor(defaultImpl == null ? fieldType.getRawClass() : defaultImpl, (JsonFormatVisitorWrapper)thiss);
                }
                catch (NoClassDefFoundError | TypeNotPresentException e) {
                    if (defaultImpl != null) {
                        return;
                    }
                    throw e;
                }
                finally {
                    ConfigurationMetadata.this.parentProps.remove(prop);
                    --ConfigurationMetadata.this.currentDepth;
                    ConfigurationMetadata.this.currentPrefix = oldPrefix;
                }
                if (oldFieldSize == ConfigurationMetadata.this.fields.size()) {
                    ConfigurationMetadata.this.fields.put(name, prop.getType());
                }
            }
        };
    }
}

