/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.awt.image.RenderedImage;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.PixelInCell;
import org.apache.sis.image.internal.shared.ImageUtilities;
import org.apache.sis.image.internal.shared.ReshapedImage;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.aggregate.ConcatenatedGridCoverage;
import org.apache.sis.storage.aggregate.GroupByCRS;
import org.apache.sis.storage.aggregate.GroupBySample;
import org.apache.sis.storage.aggregate.GroupByTransform;
import org.apache.sis.storage.aggregate.MergeStrategy;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.logging.Logging;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.GenericName;

final class GridSlice
implements Comparable<GridSlice> {
    static final int BIDIMENSIONAL = 2;
    static final PixelInCell CELL_ANCHOR = PixelInCell.CELL_CORNER;
    private final int order;
    final GridCoverageResource resource;
    final GridExtent extentInGroup;
    private final long[] offset;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GridSlice(int order, GridCoverageResource resource, GroupBySample bySample, MergeStrategy strategy) throws DataStoreException, NoninvertibleTransformException {
        List addTo;
        long[] offset;
        GroupByTransform slices;
        GridGeometry geometry;
        block7: {
            List transforms;
            this.order = order;
            this.resource = resource;
            geometry = resource.getGridGeometry();
            MathTransform gridToCRS = geometry.getGridToCRS(CELL_ANCHOR);
            MathTransform crsToGrid = gridToCRS.inverse();
            CoordinateReferenceSystem crs = geometry.isDefined(1) ? geometry.getCoordinateReferenceSystem() : null;
            GroupByCRS<GroupByTransform> crsGroup = bySample.getOrAdd(crs);
            List list = transforms = crsGroup.members;
            synchronized (list) {
                int i = transforms.size();
                while (--i >= 0) {
                    slices = (GroupByTransform)transforms.get(i);
                    offset = slices.integerTranslation(crsToGrid);
                    if (offset == null) continue;
                    break block7;
                }
                offset = new long[geometry.getDimension()];
                slices = new GroupByTransform(crsGroup, geometry, gridToCRS);
                transforms.add(slices);
            }
        }
        slices.strategy = strategy;
        offset = slices.unique(offset);
        this.offset = offset;
        this.extentInGroup = slices.unique(geometry.getExtent().translate(offset, true));
        List list = addTo = slices.members;
        synchronized (list) {
            addTo.add(this);
        }
    }

    private GridSlice(GridSlice source, GridCoverageResource coverage, GridExtent inGroup, long[] toSlice) {
        this.order = source.order;
        this.resource = coverage;
        this.extentInGroup = inGroup;
        this.offset = toSlice;
    }

    final GridSlice resolve(GridCoverageResource coverage, GridExtent extent, GridExtent inGroup) throws DataStoreReferencingException {
        long[] toSlice = new long[inGroup.getDimension()];
        int i = toSlice.length;
        while (--i >= 0) {
            long scale;
            long value = extent.getSize(i);
            if (value % (scale = inGroup.getSize(i)) == 0L) {
                scale = value / scale;
                value = extent.getLow(i);
                if (value % scale == 0L) {
                    toSlice[i] = Math.subtractExact(inGroup.getLow(i), value /= scale);
                    continue;
                }
            }
            throw new DataStoreReferencingException(Resources.format((short)72));
        }
        if (Arrays.equals(toSlice, this.offset)) {
            toSlice = this.offset;
        }
        if (inGroup.equals((Object)this.extentInGroup, ComparisonMode.IGNORE_METADATA)) {
            inGroup = this.extentInGroup;
            if (toSlice == this.offset && coverage.equals(this.resource)) {
                return this;
            }
        }
        return new GridSlice(this, coverage, inGroup, toSlice);
    }

    final Object getIdentifier() {
        try {
            Optional<GenericName> identifier = this.resource.getIdentifier();
            if (identifier.isPresent()) {
                return identifier.get();
            }
        }
        catch (DataStoreException e) {
            Logging.unexpectedException((Logger)ImageUtilities.LOGGER, ConcatenatedGridCoverage.class, (String)"render", (Throwable)e);
        }
        return this.order;
    }

    final RenderedImage render(GridCoverage coverage, GridExtent request, int[] subdim) {
        long ty;
        RenderedImage image = coverage.render(request.translate(this.offset));
        long tx = Math.negateExact(this.offset[subdim[0]]);
        if ((tx | (ty = Math.negateExact(this.offset[subdim[1]]))) == 0L) {
            return image;
        }
        ReshapedImage translated = new ReshapedImage(image, tx, ty);
        return translated.isIdentity() ? translated.source : translated;
    }

    @Override
    public final int compareTo(GridSlice other) {
        return Integer.compare(this.order, other.order);
    }

    public String toString() {
        String id = null;
        if (this.resource != null) {
            try {
                id = this.resource.getIdentifier().orElse(null);
            }
            catch (DataStoreException e) {
                id = e.toString();
            }
        }
        long[] location = new long[this.extentInGroup.getDimension()];
        long[] size = new long[location.length];
        for (int i = 0; i < location.length; ++i) {
            location[i] = this.extentInGroup.getLow(i);
            size[i] = this.extentInGroup.getSize(i);
        }
        return Strings.toString(this.getClass(), (Object[])new Object[]{null, id, "location", location, "size", size, "order", this.order});
    }
}

