/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.function.datetime;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.apache.qpid.server.query.engine.evaluator.settings.QuerySettings;
import org.apache.qpid.server.query.engine.parsing.converter.DateTimeConverter;
import org.apache.qpid.server.query.engine.parsing.converter.NumberConverter;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.function.AbstractFunctionExpression;
import org.apache.qpid.server.query.engine.validation.FunctionParameterTypePredicate;
import org.apache.qpid.server.query.engine.validation.FunctionParametersValidator;

public class DateDiffExpression<T, R>
extends AbstractFunctionExpression<T, Number> {
    private final FunctionParameterTypePredicate<R> _dateTimeValidator = FunctionParameterTypePredicate.builder().allowDateTimeTypes().allowStrings().build();

    public DateDiffExpression(String alias, List<ExpressionNode<T, ?>> args) {
        super(alias, args);
        FunctionParametersValidator.requireParameters(3, args, this);
    }

    @Override
    public Number apply(T value) {
        QuerySettings querySettings = (QuerySettings)this.ctx().get("query.settings");
        ChronoUnit datePart = (ChronoUnit)this.evaluateChild(0, null);
        R dateTime1 = this.evaluateChild(1, value, this._dateTimeValidator);
        R dateTime2 = this.evaluateChild(2, value, this._dateTimeValidator);
        Instant instant1 = DateTimeConverter.toInstantMapper().apply(dateTime1);
        Instant instant2 = DateTimeConverter.toInstantMapper().apply(dateTime2);
        return NumberConverter.narrow(datePart.between(instant1.atZone(querySettings.getZoneId()), instant2.atZone(querySettings.getZoneId())));
    }
}

