/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.session;

import java.security.AccessControlContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.Subject;
import org.apache.qpid.server.configuration.updater.Task;
import org.apache.qpid.server.connection.SessionPrincipal;
import org.apache.qpid.server.consumer.AbstractConsumerTarget;
import org.apache.qpid.server.consumer.ConsumerTarget;
import org.apache.qpid.server.consumer.ScheduledConsumerTargetSet;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.logging.LogMessage;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.Outcome;
import org.apache.qpid.server.logging.messages.ChannelMessages;
import org.apache.qpid.server.logging.subjects.ChannelLogSubject;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Consumer;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.Producer;
import org.apache.qpid.server.model.ProducerImpl;
import org.apache.qpid.server.model.PublishingLink;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.protocol.PublishAuthorisationCache;
import org.apache.qpid.server.security.SecurityToken;
import org.apache.qpid.server.session.AMQPSession;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.transport.network.Ticker;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAMQPSession<S extends AbstractAMQPSession<S, X>, X extends ConsumerTarget<X>>
extends AbstractConfiguredObject<S>
implements AMQPSession<S, X>,
EventLoggerProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAMQPSession.class);
    private final Action _deleteModelTask;
    private final AMQPConnection<?> _connection;
    private final int _sessionId;
    protected final AccessControlContext _accessControllerContext;
    protected final Subject _subject;
    protected final SecurityToken _token;
    protected final PublishAuthorisationCache _publishAuthCache;
    protected final List<Action<? super S>> _taskList = new CopyOnWriteArrayList<Action<? super S>>();
    private final AtomicInteger _consumerCount = new AtomicInteger();
    protected final Set<AbstractConsumerTarget> _consumersWithPendingWork = new ScheduledConsumerTargetSet<AbstractConsumerTarget>();
    private final LogSubject _logSubject;
    private Iterator<AbstractConsumerTarget> _processPendingIterator;
    private final Set<Consumer<?, X>> _consumers = ConcurrentHashMap.newKeySet();
    private final AtomicLong _messagesIn = new AtomicLong();
    private final AtomicLong _messagesOut = new AtomicLong();
    private final AtomicLong _transactedMessagesIn = new AtomicLong();
    private final AtomicLong _transactedMessagesOut = new AtomicLong();
    private final AtomicLong _bytesIn = new AtomicLong();
    private final AtomicLong _bytesOut = new AtomicLong();
    private final AtomicLong _producerCount = new AtomicLong();

    protected AbstractAMQPSession(Connection<?> parent, int sessionId) {
        this(parent, sessionId, new ChannelLogSubject((AMQPConnection)parent, sessionId));
    }

    protected AbstractAMQPSession(Connection<?> parent, int sessionId, LogSubject logSubject) {
        super(parent, AbstractAMQPSession.createAttributes(sessionId));
        this._connection = (AMQPConnection)parent;
        this._sessionId = sessionId;
        this._deleteModelTask = new Action<S>(){

            @Override
            public void performAction(S object) {
                AbstractAMQPSession.this.removeDeleteTask(this);
                AbstractAMQPSession.this.deleteNoChecks();
            }
        };
        this._subject = new Subject(false, this._connection.getSubject().getPrincipals(), this._connection.getSubject().getPublicCredentials(), this._connection.getSubject().getPrivateCredentials());
        this._subject.getPrincipals().add(new SessionPrincipal(this));
        if (this._connection.getAddressSpace() instanceof ConfiguredObject) {
            this._token = ((ConfiguredObject)((Object)this._connection.getAddressSpace())).newToken(this._subject);
        } else {
            Broker<?> broker = this._connection.getBroker();
            this._token = broker.newToken(this._subject);
        }
        this._accessControllerContext = this._connection.getAccessControlContextFromSubject(this._subject);
        long authCacheTimeout = this._connection.getContextValue(Long.class, "producer.authCacheTimeout");
        int authCacheSize = this._connection.getContextValue(Integer.class, "producer.authCacheSize");
        this._publishAuthCache = new PublishAuthorisationCache(this._token, authCacheTimeout, authCacheSize);
        this._logSubject = logSubject;
        this.setState(State.ACTIVE);
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        this.addDeleteTask(this._deleteModelTask);
    }

    private static Map<String, Object> createAttributes(long sessionId) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("name", sessionId);
        attributes.put("durable", false);
        attributes.put("lifetimePolicy", (Object)LifetimePolicy.DELETE_ON_SESSION_END);
        return attributes;
    }

    @Override
    public int getChannelId() {
        return this._sessionId;
    }

    @Override
    public AMQPConnection<?> getAMQPConnection() {
        return this._connection;
    }

    @Override
    public boolean isProducerFlowBlocked() {
        return this.getBlocking();
    }

    @Override
    public long getUnacknowledgedMessages() {
        return this.getUnacknowledgedMessageCount();
    }

    @Override
    public void addDeleteTask(Action<? super S> task) {
        this._taskList.add(task);
    }

    @Override
    public void removeDeleteTask(Action<? super S> task) {
        this._taskList.remove(task);
    }

    @Override
    protected CompletableFuture<Void> onDelete() {
        this.removeDeleteTask(this._deleteModelTask);
        return super.onDelete();
    }

    @Override
    public EventLogger getEventLogger() {
        return this._connection.getEventLogger();
    }

    @Override
    public void addTicker(Ticker ticker) {
        this._connection.getAggregateTicker().addTicker(ticker);
        this.getAMQPConnection().notifyWork();
    }

    @Override
    public void removeTicker(Ticker ticker) {
        this._connection.getAggregateTicker().removeTicker(ticker);
    }

    @Override
    public LogSubject getLogSubject() {
        return this._logSubject;
    }

    @Override
    protected void logOperation(String operation) {
        this.getEventLogger().message(ChannelMessages.OPERATION(operation));
    }

    @Override
    public boolean processPending() {
        if (!this.getAMQPConnection().isIOThread() || this.isClosing()) {
            return false;
        }
        this.updateBlockedStateIfNecessary();
        if (!this._consumersWithPendingWork.isEmpty() && !this.getAMQPConnection().isTransportBlockedForWriting()) {
            if (this._processPendingIterator == null || !this._processPendingIterator.hasNext()) {
                this._processPendingIterator = this._consumersWithPendingWork.iterator();
            }
            if (this._processPendingIterator.hasNext()) {
                AbstractConsumerTarget target = this._processPendingIterator.next();
                this._processPendingIterator.remove();
                if (target.processPending()) {
                    this._consumersWithPendingWork.add(target);
                }
            }
        }
        return !this._consumersWithPendingWork.isEmpty() && !this.getAMQPConnection().isTransportBlockedForWriting();
    }

    @Override
    public void notifyWork(X target) {
        if (this._consumersWithPendingWork.add((AbstractConsumerTarget)target)) {
            this.getAMQPConnection().notifyWork(this);
        }
    }

    @Override
    public final long getConsumerCount() {
        return this._consumerCount.get();
    }

    @Override
    public final void consumerAdded(Consumer<?, X> consumer) {
        this._consumerCount.incrementAndGet();
        this._consumers.add(consumer);
    }

    @Override
    public final void consumerRemoved(Consumer<?, X> consumer) {
        this._consumerCount.decrementAndGet();
        this._consumers.remove(consumer);
    }

    @Override
    public Set<? extends Consumer<?, ?>> getConsumers() {
        return Collections.unmodifiableSet(this._consumers);
    }

    protected abstract void updateBlockedStateIfNecessary();

    public abstract boolean isClosing();

    @Override
    public CompletableFuture<Void> doOnIOThreadAsync(Runnable task) {
        return this.getAMQPConnection().doOnIOThreadAsync(task).whenComplete((result, error) -> this.getAMQPConnection().notifyWork(this));
    }

    @Override
    public long getBytesIn() {
        return this._bytesIn.get();
    }

    @Override
    public long getBytesOut() {
        return this._bytesOut.get();
    }

    @Override
    public long getMessagesIn() {
        return this._messagesIn.get();
    }

    @Override
    public long getMessagesOut() {
        return this._messagesOut.get();
    }

    @Override
    public long getTransactedMessagesIn() {
        return this._transactedMessagesIn.get();
    }

    @Override
    public long getTransactedMessagesOut() {
        return this._transactedMessagesOut.get();
    }

    @Override
    public void registerMessageDelivered(long messageSize) {
        this._messagesOut.incrementAndGet();
        this._bytesOut.addAndGet(messageSize);
        this._connection.registerMessageDelivered(messageSize);
    }

    @Override
    public void registerMessageReceived(long messageSize) {
        this._messagesIn.incrementAndGet();
        this._bytesIn.addAndGet(messageSize);
        this._connection.registerMessageReceived(messageSize);
    }

    @Override
    public void registerTransactedMessageDelivered() {
        this._transactedMessagesOut.incrementAndGet();
        this._connection.registerTransactedMessageDelivered();
    }

    @Override
    public void registerTransactedMessageReceived() {
        this._transactedMessagesIn.incrementAndGet();
        this._connection.registerTransactedMessageReceived();
    }

    @Override
    public void resetStatistics() {
        this._bytesIn.set(0L);
        this._bytesOut.set(0L);
        this._messagesIn.set(0L);
        this._messagesOut.set(0L);
        this._transactedMessagesIn.set(0L);
        this._transactedMessagesOut.set(0L);
    }

    @Override
    public long getProducerCount() {
        return this._producerCount.get();
    }

    public Producer<?> addProducer(PublishingLink link, MessageDestination messageDestination) {
        if ("link".equals(link.getType())) {
            this._producerCount.incrementAndGet();
            return this.createProducer(this, link, messageDestination);
        }
        return null;
    }

    public void removeProducer(PublishingLink link) {
        Producer producer = this.getChildByName(Producer.class, link.getName());
        if (producer != null) {
            producer.deleteNoChecks();
            this._producerCount.decrementAndGet();
        }
    }

    private Producer<?> createProducer(final AbstractAMQPSession<?, ?> session, final PublishingLink publishingLink, final MessageDestination messageDestination) throws ConnectionScopedRuntimeException {
        return (Producer)this.getTaskExecutor().run(new Task<Producer<?>, ConnectionScopedRuntimeException>(){

            @Override
            public Producer<?> execute() {
                return new ProducerImpl(session, publishingLink, messageDestination);
            }

            @Override
            public String getObject() {
                return AbstractAMQPSession.this.toString();
            }

            @Override
            public String getAction() {
                return "create producer";
            }

            @Override
            public String getArguments() {
                return "session=" + String.valueOf(session) + ", publishingLink=" + String.valueOf(publishingLink) + ", messageDestination=" + String.valueOf(messageDestination);
            }
        });
    }

    @Override
    protected void logCreated(Map<String, Object> attributes, Outcome outcome) {
        LOGGER.debug("{} : {} ({}) : Create : {}", new Object[]{LogMessage.getActor(), this.getCategoryClass().getSimpleName(), this.getName(), outcome});
    }

    @Override
    protected void logDeleted(Outcome outcome) {
        LOGGER.debug("{} : {} ({}) : Delete : {}", new Object[]{LogMessage.getActor(), this.getCategoryClass().getSimpleName(), this.getName(), outcome});
    }
}

