/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.CustomRestHeaders;
import org.apache.qpid.server.model.RestContentHeader;

public class PathContent
implements Content,
CustomRestHeaders {
    private final Path _path;
    private final String _contentType;
    private final String _disposition;
    private final long _contentSize;

    public PathContent(Path path, String contentType) {
        this._path = path;
        this._contentType = contentType;
        this._disposition = this._path == null ? "attachment" : "attachment; filename=\"" + this._path.getFileName().toString() + "\"";
        this._contentSize = this._path == null ? 0L : this._path.toFile().length();
    }

    @RestContentHeader(value="Content-Type")
    public String getContentType() {
        return this._contentType;
    }

    @RestContentHeader(value="Content-Disposition")
    public String getContentDisposition() {
        return this._disposition;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        if (this._path == null || !this._path.toFile().exists()) {
            throw new FileNotFoundException();
        }
        Files.copy(this._path, outputStream);
    }

    @Override
    public void release() {
    }
}

