/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import org.apache.pulsar.client.api.MessageIdAdv;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.common.api.proto.MessageIdData;

public class ChunkMessageIdImpl
extends MessageIdImpl {
    private final MessageIdImpl firstChunkMsgId;

    public ChunkMessageIdImpl(MessageIdImpl firstChunkMsgId, MessageIdImpl lastChunkMsgId) {
        super(lastChunkMsgId.getLedgerId(), lastChunkMsgId.getEntryId(), lastChunkMsgId.getPartitionIndex());
        this.firstChunkMsgId = firstChunkMsgId;
    }

    public MessageIdAdv getFirstChunkMessageId() {
        return this.firstChunkMsgId;
    }

    public MessageIdAdv getLastChunkMessageId() {
        return this;
    }

    @Override
    public String toString() {
        return this.firstChunkMsgId.toString() + ';' + super.toString();
    }

    @Override
    public byte[] toByteArray() {
        MessageIdData msgId = super.writeMessageIdData(null, -1, 0);
        msgId.setFirstChunkMessageId();
        this.firstChunkMsgId.writeMessageIdData(msgId.getFirstChunkMessageId(), -1, 0);
        int size = msgId.getSerializedSize();
        ByteBuf serialized = Unpooled.buffer((int)size, (int)size);
        msgId.writeTo(serialized);
        return serialized.array();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.firstChunkMsgId.hashCode());
    }
}

