/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.cpplite.project.ui.wizard;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cpplite.project.ui.wizard.CPPLiteProjectWizardIterator.CPPLiteProjectSettings;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;

/**
 *
 * @author lahvac
 */
public class CPPLiteProjectPathPanel extends javax.swing.JPanel {

    private final ChangeSupport cs = new ChangeSupport(this);

    private volatile boolean valid;

    /**
     * Creates new form CPPLiteProjectPathPanel
     */
    public CPPLiteProjectPathPanel() {
        initComponents();
        path.getDocument().addDocumentListener(new DocumentListener() {
            @Override
            public void insertUpdate(DocumentEvent e) {
                pathUpdated();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                pathUpdated();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        pathUpdated();
    }

    private void pathUpdated() {
        String text = path.getText();
        FileObject projectDirectory = FileUtil.toFileObject(FileUtil.normalizeFile(new File(text)));
        
        valid = projectDirectory != null && projectDirectory.isFolder() && !text.isEmpty();
        cs.fireChange();
    }

    public void addChangeListener(ChangeListener l) {
        cs.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        cs.removeChangeListener(l);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        fileChooser = new javax.swing.JButton();
        path = new javax.swing.JTextField();

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(CPPLiteProjectPathPanel.class, "CPPLiteProjectPathPanel.jLabel1.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(fileChooser, org.openide.util.NbBundle.getMessage(CPPLiteProjectPathPanel.class, "CPPLiteProjectPathPanel.fileChooser.text")); // NOI18N
        fileChooser.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fileChooserActionPerformed(evt);
            }
        });

        path.setText(org.openide.util.NbBundle.getMessage(CPPLiteProjectPathPanel.class, "CPPLiteProjectPathPanel.path.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(path, javax.swing.GroupLayout.DEFAULT_SIZE, 265, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(fileChooser))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                .addComponent(fileChooser)
                .addComponent(path, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addComponent(jLabel1))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void fileChooserActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fileChooserActionPerformed
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        fc.setSelectedFile(new File(path.getText()));
        if (fc.showDialog(this, "Select") == JFileChooser.APPROVE_OPTION) {
            path.setText(fc.getSelectedFile().getAbsolutePath());
        }
    }//GEN-LAST:event_fileChooserActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton fileChooser;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JTextField path;
    // End of variables declaration//GEN-END:variables

    public static class PanelImpl implements WizardDescriptor.FinishablePanel<WizardDescriptor> {

        private CPPLiteProjectPathPanel panel;

        @Override
        public CPPLiteProjectPathPanel getComponent() {
            if (panel == null) {
                panel = new CPPLiteProjectPathPanel();
            }
            return panel;
        }

        @Override
        public HelpCtx getHelp() {
            return HelpCtx.DEFAULT_HELP;
        }

        @Override
        public void readSettings(WizardDescriptor wizard) {
            CPPLiteProjectSettings settings = CPPLiteProjectSettings.get(wizard);
            String path = settings.getProjectPath();
            if (path == null) {
                path = "";
            }
            getComponent().path.setText(path);
        }

        @Override
        public void storeSettings(WizardDescriptor wizard) {
            CPPLiteProjectSettings.get(wizard).setProjectPath(getComponent().path.getText());
        }

        @Override
        public boolean isValid() {
            return getComponent().valid;
        }

        @Override
        public void addChangeListener(ChangeListener l) {
            getComponent().addChangeListener(l);
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
            getComponent().removeChangeListener(l);
        }

        @Override
        public boolean isFinishPanel() {
            return true;
        }

    }
}
