/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.metrics.impl.instr;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InstrUtils {
    private static final Pattern p = Pattern.compile("/.*?/.*?/");
    private static final Pattern serviceP = Pattern.compile("/.*?/");

    public static String getResourcePath(String fullPath) {
        return InstrUtils.getMatchedPath(fullPath, p);
    }

    public static String getServiceResourcePath(String fullPath) {
        return InstrUtils.getMatchedPath(fullPath, serviceP);
    }

    private static String getMatchedPath(String fullPath, Pattern pattern) {
        String resourcePath = "";
        if (fullPath != null && !fullPath.isEmpty()) {
            Matcher m = pattern.matcher(fullPath);
            resourcePath = m.find() ? m.group(0) : fullPath;
        }
        return resourcePath;
    }
}

