/*
 * Decompiled with CFR 0.152.
 */
package de.thetaphi.forbiddenapis;

import de.thetaphi.forbiddenapis.AsmUtils;
import de.thetaphi.forbiddenapis.ClassMetadata;
import de.thetaphi.forbiddenapis.ClassScanner;
import de.thetaphi.forbiddenapis.Constants;
import de.thetaphi.forbiddenapis.ForbiddenApiException;
import de.thetaphi.forbiddenapis.ForbiddenViolation;
import de.thetaphi.forbiddenapis.Logger;
import de.thetaphi.forbiddenapis.ParseException;
import de.thetaphi.forbiddenapis.RelatedClassLoadingException;
import de.thetaphi.forbiddenapis.RelatedClassLookup;
import de.thetaphi.forbiddenapis.Signatures;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import de.thetaphi.forbiddenapis.asm.ClassReader;
import de.thetaphi.forbiddenapis.asm.Type;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Pattern;

public final class Checker
implements RelatedClassLookup,
Constants {
    public final boolean isSupportedJDK;
    private final long start;
    private final NavigableSet<String> runtimePaths;
    final Logger logger;
    final ClassLoader loader;
    final Method method_Class_getModule;
    final Method method_Module_getName;
    final EnumSet<Option> options;
    final Map<String, ClassMetadata> classesToCheck = new HashMap<String, ClassMetadata>();
    final Map<String, ClassMetadata> classpathClassCache = new HashMap<String, ClassMetadata>();
    final Set<String> missingClasses = new TreeSet<String>();
    final Signatures forbiddenSignatures;
    final Set<String> suppressAnnotations = new LinkedHashSet<String>();

    public Checker(Logger logger, ClassLoader loader, Option ... options) {
        this(logger, loader, options.length == 0 ? EnumSet.noneOf(Option.class) : EnumSet.copyOf(Arrays.asList(options)));
    }

    public Checker(Logger logger, ClassLoader loader, EnumSet<Option> options) {
        Method method_Module_getName;
        Method method_Class_getModule;
        this.logger = logger;
        this.loader = loader;
        this.options = options;
        this.start = System.currentTimeMillis();
        this.addSuppressAnnotation(SuppressForbidden.class);
        boolean isSupportedJDK = false;
        try {
            method_Class_getModule = Class.class.getMethod("getModule", new Class[0]);
            method_Module_getName = method_Class_getModule.getReturnType().getMethod("getName", new Class[0]);
            isSupportedJDK = true;
            logger.debug("Detected Java 9 or later with module system.");
        }
        catch (NoSuchMethodException e) {
            method_Module_getName = null;
            method_Class_getModule = null;
        }
        this.method_Class_getModule = method_Class_getModule;
        this.method_Module_getName = method_Module_getName;
        TreeSet<String> runtimePaths = new TreeSet<String>();
        if (!isSupportedJDK) {
            try {
                URL objectClassURL = loader.getResource(AsmUtils.getClassResourceName(Object.class.getName()));
                if (objectClassURL != null && "jrt".equalsIgnoreCase(objectClassURL.getProtocol())) {
                    isSupportedJDK = true;
                    logger.debug("Detected Java 9 or later with JRT file system.");
                } else {
                    RuntimeMXBean rb;
                    String javaHome = System.getProperty("java.home");
                    if (javaHome != null) {
                        if (!(javaHome = new File(javaHome).getCanonicalPath()).endsWith(File.separator)) {
                            javaHome = javaHome + File.separator;
                        }
                        runtimePaths.add(javaHome);
                    }
                    if ((rb = ManagementFactory.getRuntimeMXBean()).isBootClassPathSupported()) {
                        String cp = rb.getBootClassPath();
                        StringTokenizer st = new StringTokenizer(cp, File.pathSeparator);
                        while (st.hasMoreTokens()) {
                            File f = new File(st.nextToken().trim());
                            if (f.isFile()) {
                                f = f.getParentFile();
                            }
                            if (!f.exists()) continue;
                            String fp = f.getCanonicalPath();
                            if (!fp.endsWith(File.separator)) {
                                fp = fp + File.separator;
                            }
                            runtimePaths.add(fp);
                        }
                    }
                    boolean bl = isSupportedJDK = !runtimePaths.isEmpty();
                    if (isSupportedJDK) {
                        logger.debug("Detected classical classpath-based JDK @ " + runtimePaths);
                    } else {
                        logger.warn("Boot classpath appears to be empty or ${java.home} not defined; marking runtime as not suppported.");
                    }
                }
            }
            catch (IOException ioe) {
                logger.warn("Cannot scan boot classpath and ${java.home} due to IO exception; marking runtime as not suppported: " + ioe);
                isSupportedJDK = false;
                runtimePaths.clear();
            }
        }
        this.runtimePaths = runtimePaths;
        if (isSupportedJDK) {
            try {
                isSupportedJDK = this.getClassFromClassLoader((String)Object.class.getName()).isRuntimeClass;
                if (!isSupportedJDK) {
                    logger.warn("Bytecode of java.lang.Object does not seem to come from runtime library; marking runtime as not suppported.");
                }
            }
            catch (IllegalArgumentException iae) {
                logger.warn("Bundled version of ASM cannot parse bytecode of java.lang.Object class; marking runtime as not suppported.");
                isSupportedJDK = false;
            }
            catch (ClassNotFoundException cnfe) {
                logger.warn("Bytecode or Class<?> instance of java.lang.Object not found; marking runtime as not suppported.");
                isSupportedJDK = false;
            }
            catch (IOException ioe) {
                logger.warn("IOException while loading java.lang.Object class from classloader; marking runtime as not suppported: " + ioe);
                isSupportedJDK = false;
            }
        }
        this.isSupportedJDK = isSupportedJDK;
        this.forbiddenSignatures = new Signatures(this);
    }

    private ClassMetadata loadClassFromJigsaw(String classname) throws IOException {
        String moduleName;
        Class<?> clazz;
        if (this.method_Class_getModule == null || this.method_Module_getName == null) {
            return null;
        }
        try {
            clazz = Class.forName(classname, false, this.loader);
            Object module = this.method_Class_getModule.invoke(clazz, new Object[0]);
            moduleName = (String)this.method_Module_getName.invoke(module, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
        return new ClassMetadata(clazz, AsmUtils.isRuntimeModule(moduleName));
    }

    private boolean isRuntimePath(URL url) throws IOException {
        if (!"file".equalsIgnoreCase(url.getProtocol())) {
            return false;
        }
        try {
            String path = new File(url.toURI()).getCanonicalPath();
            String lookup = this.runtimePaths.floor(path);
            return lookup != null && path.startsWith(lookup);
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private boolean isRuntimeClass(URLConnection conn) throws IOException {
        URL url = conn.getURL();
        if (this.isRuntimePath(url)) {
            return true;
        }
        if ("jar".equalsIgnoreCase(url.getProtocol()) && conn instanceof JarURLConnection) {
            URL jarUrl = ((JarURLConnection)conn).getJarFileURL();
            return this.isRuntimePath(jarUrl);
        }
        if ("jrt".equalsIgnoreCase(url.getProtocol())) {
            return AsmUtils.isRuntimeModule(AsmUtils.getModuleName(url));
        }
        return false;
    }

    @Override
    public ClassMetadata getClassFromClassLoader(String clazz) throws ClassNotFoundException, IOException {
        if (this.classpathClassCache.containsKey(clazz)) {
            ClassMetadata c = this.classpathClassCache.get(clazz);
            if (c == null) {
                throw new ClassNotFoundException(clazz);
            }
            return c;
        }
        URL url = this.loader.getResource(AsmUtils.getClassResourceName(clazz));
        if (url != null) {
            ClassReader cr;
            URLConnection conn = url.openConnection();
            boolean isRuntimeClass = this.isRuntimeClass(conn);
            if (!isRuntimeClass && this.options.contains((Object)Option.DISABLE_CLASSLOADING_CACHE)) {
                conn.setUseCaches(false);
            }
            try (InputStream in = conn.getInputStream();){
                cr = AsmUtils.readAndPatchClass(in);
            }
            catch (IllegalArgumentException iae) {
                ClassMetadata c;
                if (isRuntimeClass && (c = this.loadClassFromJigsaw(clazz)) != null) {
                    this.classpathClassCache.put(clazz, c);
                    return c;
                }
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "The class file format of '%s' (loaded from location '%s') is too recent to be parsed by ASM.", clazz, url.toExternalForm()));
            }
            ClassMetadata c = new ClassMetadata(cr, isRuntimeClass, false);
            this.classpathClassCache.put(clazz, c);
            return c;
        }
        ClassMetadata c = this.loadClassFromJigsaw(clazz);
        if (c != null) {
            this.classpathClassCache.put(clazz, c);
            return c;
        }
        c = this.classesToCheck.get(clazz);
        if (c != null) {
            this.classpathClassCache.put(clazz, c);
            return c;
        }
        this.classpathClassCache.put(clazz, null);
        throw new ClassNotFoundException(clazz);
    }

    @Override
    public ClassMetadata lookupRelatedClass(String internalName, String internalNameOrig) {
        Type type = Type.getObjectType(internalName);
        if (type.getSort() != 10) {
            return null;
        }
        try {
            return this.getClassFromClassLoader(type.getClassName());
        }
        catch (ClassNotFoundException cnfe) {
            String origClassName = Type.getObjectType(internalNameOrig).getClassName();
            if (this.options.contains((Object)Option.FAIL_ON_MISSING_CLASSES)) {
                throw new RelatedClassLoadingException(cnfe, origClassName);
            }
            this.logger.debug(String.format(Locale.ENGLISH, "Class '%s' cannot be loaded (while looking up details about referenced class '%s').", type.getClassName(), origClassName));
            this.missingClasses.add(type.getClassName());
            return null;
        }
        catch (IOException ioe) {
            throw new RelatedClassLoadingException(ioe, Type.getObjectType(internalNameOrig).getClassName());
        }
        catch (RuntimeException re) {
            if (AsmUtils.isExceptionInAsmClassReader(re)) {
                throw new RelatedClassLoadingException(re, Type.getObjectType(internalNameOrig).getClassName());
            }
            throw re;
        }
    }

    public void addBundledSignatures(String name, String jdkTargetVersion) throws IOException, ParseException {
        this.forbiddenSignatures.addBundledSignatures(name, jdkTargetVersion);
    }

    public void parseSignaturesFile(InputStream in, String name) throws IOException, ParseException {
        this.forbiddenSignatures.parseSignaturesStream(in, name);
    }

    public void parseSignaturesFile(URL url) throws IOException, ParseException {
        this.parseSignaturesFile(url.openStream(), url.toString());
    }

    public void parseSignaturesFile(File f) throws IOException, ParseException {
        this.parseSignaturesFile(new FileInputStream(f), f.toString());
    }

    public void parseSignaturesString(String signatures) throws IOException, ParseException {
        this.forbiddenSignatures.parseSignaturesString(signatures);
    }

    public boolean hasNoSignatures() {
        return this.forbiddenSignatures.hasNoSignatures();
    }

    public boolean noSignaturesFilesParsed() {
        return this.forbiddenSignatures.noSignaturesFilesParsed();
    }

    public void addClassToCheck(InputStream in, String name) throws IOException {
        ClassReader reader;
        try (InputStream in_ = in;){
            reader = AsmUtils.readAndPatchClass(in_);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "The class file format of '%s' is too recent to be parsed by ASM.", name));
        }
        ClassMetadata metadata = new ClassMetadata(reader, false, true);
        this.classesToCheck.put(metadata.getBinaryClassName(), metadata);
    }

    public void addClassToCheck(File f) throws IOException {
        this.addClassToCheck(new FileInputStream(f), f.toString());
    }

    public void addClassesToCheck(Iterable<File> files) throws IOException {
        this.logger.info("Loading classes to check...");
        for (File f : files) {
            this.addClassToCheck(f);
        }
    }

    public void addClassesToCheck(File ... files) throws IOException {
        this.addClassesToCheck(Arrays.asList(files));
    }

    public void addClassesToCheck(File basedir, Iterable<String> relativeNames) throws IOException {
        this.logger.info("Loading classes to check...");
        for (String f : relativeNames) {
            this.addClassToCheck(new File(basedir, f));
        }
    }

    public void addClassesToCheck(File basedir, String ... relativeNames) throws IOException {
        this.addClassesToCheck(basedir, Arrays.asList(relativeNames));
    }

    public void addSuppressAnnotation(Class<? extends Annotation> anno) {
        this.suppressAnnotations.add(anno.getName());
    }

    public void addSuppressAnnotation(String annoName) {
        this.suppressAnnotations.add(annoName);
    }

    private int checkClass(ClassMetadata c, Pattern suppressAnnotationsPattern) throws ForbiddenApiException {
        String className = c.getBinaryClassName();
        ClassScanner scanner = new ClassScanner(c, this, this.forbiddenSignatures, suppressAnnotationsPattern);
        try {
            c.getReader().accept(scanner, 4);
        }
        catch (RelatedClassLoadingException rcle) {
            Exception cause = rcle.getException();
            StringBuilder msg = new StringBuilder().append("Check for forbidden API calls failed while scanning class '").append(className).append('\'');
            String source = scanner.getSourceFile();
            if (source != null) {
                msg.append(" (").append(source).append(')');
            }
            msg.append(": ").append(cause);
            msg.append(" (while looking up details about referenced class '").append(rcle.getClassName()).append("')");
            assert (cause != null && (cause instanceof IOException || cause instanceof ClassNotFoundException || cause instanceof RuntimeException));
            throw new ForbiddenApiException(msg.toString(), cause);
        }
        catch (RuntimeException re) {
            if (AsmUtils.isExceptionInAsmClassReader(re)) {
                StringBuilder msg = new StringBuilder().append("Failed to parse class '").append(className).append('\'');
                String source = scanner.getSourceFile();
                if (source != null) {
                    msg.append(" (").append(source).append(')');
                }
                msg.append(": ").append(re);
                throw new ForbiddenApiException(msg.toString(), re);
            }
            throw re;
        }
        List<ForbiddenViolation> violations = scanner.getSortedViolations();
        Pattern splitter = Pattern.compile(Pattern.quote("\n"));
        for (ForbiddenViolation v : violations) {
            for (String line : splitter.split(v.format(className, scanner.getSourceFile()))) {
                this.logger.error(line);
            }
        }
        return violations.size();
    }

    public void run() throws ForbiddenApiException {
        this.logger.info("Scanning classes for violations...");
        int errors = 0;
        Pattern suppressAnnotationsPattern = AsmUtils.glob2Pattern(this.suppressAnnotations.toArray(new String[this.suppressAnnotations.size()]));
        for (ClassMetadata c : this.classesToCheck.values()) {
            errors += this.checkClass(c, suppressAnnotationsPattern);
        }
        if (!this.missingClasses.isEmpty()) {
            this.logger.warn("While scanning classes to check, the following referenced classes were not found on classpath (this may miss some violations):");
            this.logger.warn(AsmUtils.formatClassesAbbreviated(this.missingClasses));
        }
        String message = String.format(Locale.ENGLISH, "Scanned %d class file(s) for forbidden API invocations (in %.2fs), %d error(s).", this.classesToCheck.size(), (double)(System.currentTimeMillis() - this.start) / 1000.0, errors);
        if (this.options.contains((Object)Option.FAIL_ON_VIOLATION) && errors > 0) {
            this.logger.error(message);
            throw new ForbiddenApiException("Check for forbidden API calls failed, see log.");
        }
        this.logger.info(message);
    }

    public static enum Option {
        FAIL_ON_MISSING_CLASSES,
        FAIL_ON_VIOLATION,
        FAIL_ON_UNRESOLVABLE_SIGNATURES,
        IGNORE_SIGNATURES_OF_MISSING_CLASSES,
        DISABLE_CLASSLOADING_CACHE;

    }
}

