/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.junit.bct;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.junit.bct.BctConfiguration;
import org.apache.juneau.junit.bct.BctUtils;
import org.apache.juneau.junit.bct.BeanConverter;
import org.apache.juneau.junit.bct.NestedTokenizer;
import org.junit.jupiter.api.Assertions;
import org.opentest4j.AssertionFailedError;

public class BctAssertions {
    public static void assertBean(Object actual, String fields, String expected) {
        BctAssertions.assertBean(null, actual, fields, expected);
    }

    public static void assertBean(Supplier<String> message, Object actual, String fields, String expected) {
        Assertions.assertNotNull((Object)actual, (String)"Actual was null.");
        AssertionUtils.assertArgNotNull((String)"fields", (Object)fields);
        AssertionUtils.assertArgNotNull((String)"expected", (Object)expected);
        BeanConverter converter = BctConfiguration.getConverter();
        Assertions.assertEquals((Object)expected, (Object)BctUtils.tokenize(fields).stream().map(x -> converter.getNested(actual, (NestedTokenizer.Token)x)).collect(Collectors.joining(",")), BctAssertions.composeMessage(message, "Bean assertion failed.", new Object[0]));
    }

    public static void assertBeans(Object actual, String fields, String ... expected) {
        BctAssertions.assertBeans(null, actual, fields, expected);
    }

    public static void assertBeans(Supplier<String> message, Object actual, String fields, String ... expected) {
        Assertions.assertNotNull((Object)actual, (String)"Value was null.");
        AssertionUtils.assertArgNotNull((String)"fields", (Object)fields);
        AssertionUtils.assertArgNotNull((String)"expected", (Object)expected);
        BeanConverter converter = BctConfiguration.getConverter();
        List<NestedTokenizer.Token> tokens = BctUtils.tokenize(fields);
        ArrayList<AssertionFailedError> errors = new ArrayList<AssertionFailedError>();
        List<Object> actualList = converter.listify(actual);
        if (Utils.neq((Object)expected.length, (Object)actualList.size())) {
            errors.add(BctUtils.assertEqualsFailed(expected.length, actualList.size(), BctAssertions.composeMessage(message, "Wrong number of beans.", new Object[0])));
        } else {
            for (int i = 0; i < actualList.size(); ++i) {
                String a;
                int i2 = i;
                String e = converter.stringify(expected[i]);
                if (!Utils.neq((Object)e, (Object)(a = tokens.stream().map(x -> converter.getNested(actualList.get(i2), (NestedTokenizer.Token)x)).collect(Collectors.joining(","))))) continue;
                errors.add(BctUtils.assertEqualsFailed(e, a, BctAssertions.composeMessage(message, "Bean at row <{0}> did not match.", i)));
            }
        }
        if (errors.isEmpty()) {
            return;
        }
        ArrayList<String> actualStrings = new ArrayList<String>();
        for (Object o : actualList) {
            actualStrings.add(tokens.stream().map(x -> converter.getNested(o, (NestedTokenizer.Token)x)).collect(Collectors.joining(",")));
        }
        throw BctUtils.assertEqualsFailed(Stream.of(expected).map(StringUtils::escapeForJava).collect(Collectors.joining("\", \"", "\"", "\"")), actualStrings.stream().map(StringUtils::escapeForJava).collect(Collectors.joining("\", \"", "\"", "\"")), BctAssertions.composeMessage(message, "{0} bean assertions failed:\n{1}", errors.size(), errors.stream().map(x -> x.getMessage()).collect(Collectors.joining("\n"))));
    }

    public static void assertContains(String expected, Object actual) {
        BctAssertions.assertContains(null, expected, actual);
    }

    public static void assertContains(Supplier<String> message, String expected, Object actual) {
        AssertionUtils.assertArgNotNull((String)"expected", (Object)expected);
        AssertionUtils.assertArgNotNull((String)"actual", (Object)actual);
        Assertions.assertNotNull((Object)actual, (String)"Value was null.");
        String a = BctConfiguration.getConverter().stringify(actual);
        Assertions.assertTrue((boolean)a.contains(expected), BctAssertions.composeMessage(message, "String did not contain expected substring.  ==> expected: <{0}> but was: <{1}>", expected, a));
    }

    public static void assertContainsAll(Object actual, String ... expected) {
        BctAssertions.assertContainsAll(null, actual, expected);
    }

    public static void assertContainsAll(Supplier<String> message, Object actual, String ... expected) {
        AssertionUtils.assertArgNotNull((String)"expected", (Object)expected);
        Assertions.assertNotNull((Object)actual, (String)"Value was null.");
        String a = BctConfiguration.getConverter().stringify(actual);
        ArrayList<AssertionFailedError> errors = new ArrayList<AssertionFailedError>();
        for (String e : expected) {
            if (a.contains(e)) continue;
            errors.add(BctUtils.assertEqualsFailed(true, false, BctAssertions.composeMessage(message, "String did not contain expected substring.  ==> expected: <{0}> but was: <{1}>", e, a)));
        }
        if (errors.isEmpty()) {
            return;
        }
        if (errors.size() == 1) {
            throw (AssertionFailedError)errors.get(0);
        }
        ArrayList<String> missingSubstrings = new ArrayList<String>();
        for (String e : expected) {
            if (a.contains(e)) continue;
            missingSubstrings.add(e);
        }
        throw BctUtils.assertEqualsFailed(missingSubstrings.stream().map(StringUtils::escapeForJava).collect(Collectors.joining("\", \"", "\"", "\"")), StringUtils.escapeForJava((String)a), BctAssertions.composeMessage(message, "{0} substring assertions failed:\n{1}", errors.size(), errors.stream().map(x -> x.getMessage()).collect(Collectors.joining("\n"))));
    }

    public static void assertEmpty(Object value) {
        BctAssertions.assertEmpty(null, value);
    }

    public static void assertEmpty(Supplier<String> message, Object value) {
        Assertions.assertNotNull((Object)value, (String)"Value was null.");
        int size = BctConfiguration.getConverter().size(value);
        Assertions.assertEquals((int)0, (int)size, BctAssertions.composeMessage(message, "Value was not empty. Size=<{0}>", size));
    }

    public static void assertList(Object actual, Object ... expected) {
        AssertionUtils.assertArgNotNull((String)"actual", (Object)actual);
        BctAssertions.assertList(null, actual, expected);
    }

    public static void assertList(Supplier<String> message, Object actual, Object ... expected) {
        AssertionUtils.assertArgNotNull((String)"expected", (Object)expected);
        AssertionUtils.assertArgNotNull((String)"actual", (Object)actual);
        BeanConverter converter = BctConfiguration.getConverter();
        List<Object> list = converter.listify(actual);
        ArrayList<AssertionFailedError> errors = new ArrayList<AssertionFailedError>();
        if (Utils.neq((Object)expected.length, (Object)list.size())) {
            errors.add(BctUtils.assertEqualsFailed(expected.length, list.size(), BctAssertions.composeMessage(message, "Wrong list length.", new Object[0])));
        } else {
            for (int i = 0; i < expected.length; ++i) {
                Object x2 = list.get(i);
                Object e = expected[i];
                if (e instanceof String) {
                    String e2 = (String)e;
                    if (!Utils.neq((Object)e2, (Object)converter.stringify(x2))) continue;
                    errors.add(BctUtils.assertEqualsFailed(e2, converter.stringify(x2), BctAssertions.composeMessage(message, "Element at index {0} did not match.", i)));
                    continue;
                }
                if (e instanceof Predicate) {
                    Predicate e2 = (Predicate)e;
                    if (e2.test(x2)) continue;
                    errors.add(new AssertionFailedError(BctAssertions.composeMessage(message, "Element at index {0} did not pass predicate.  ==> actual: <{1}>", i, converter.stringify(x2)).get()));
                    continue;
                }
                if (!Utils.neq((Object)e, (Object)x2)) continue;
                errors.add(BctUtils.assertEqualsFailed(e, x2, BctAssertions.composeMessage(message, "Element at index {0} did not match.  ==> expected: <{1}({2})> but was: <{3}({4})>", i, e, Utils.cns((Object)e), x2, Utils.cns((Object)x2))));
            }
        }
        if (errors.isEmpty()) {
            return;
        }
        ArrayList<String> actualStrings = new ArrayList<String>();
        for (Object o : list) {
            actualStrings.add(converter.stringify(o));
        }
        if (errors.size() == 1) {
            throw (AssertionFailedError)errors.get(0);
        }
        throw BctUtils.assertEqualsFailed(Stream.of(expected).map(converter::stringify).map(StringUtils::escapeForJava).collect(Collectors.joining("\", \"", "[\"", "\"]")), actualStrings.stream().map(StringUtils::escapeForJava).collect(Collectors.joining("\", \"", "[\"", "\"]")), BctAssertions.composeMessage(message, "{0} list assertions failed:\n{1}", errors.size(), errors.stream().map(x -> x.getMessage()).collect(Collectors.joining("\n"))));
    }

    public static void assertMap(Map<?, ?> actual, Object ... expected) {
        BctAssertions.assertMap(null, actual, expected);
    }

    public static void assertMap(Supplier<String> message, Map<?, ?> actual, Object ... expected) {
        BctAssertions.assertList(message, actual, expected);
    }

    public static <T> void assertMapped(Supplier<String> message, T actual, BiFunction<T, String, Object> function, String properties, String expected) {
        Assertions.assertNotNull(actual, (String)"Value was null.");
        AssertionUtils.assertArgNotNull((String)"function", function);
        AssertionUtils.assertArgNotNull((String)"properties", (Object)properties);
        AssertionUtils.assertArgNotNull((String)"expected", (Object)expected);
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (NestedTokenizer.Token p : BctUtils.tokenize(properties)) {
            String pv = p.getValue();
            m.put(pv, Utils.safe(() -> function.apply(actual, pv)));
        }
        BctAssertions.assertBean(message, m, properties, expected);
    }

    public static <T> void assertMapped(T actual, BiFunction<T, String, Object> function, String properties, String expected) {
        BctAssertions.assertMapped(null, actual, function, properties, expected);
    }

    public static void assertMatchesGlob(String pattern, Object value) {
        BctAssertions.assertMatchesGlob(null, pattern, value);
    }

    public static void assertMatchesGlob(Supplier<String> message, String pattern, Object value) {
        AssertionUtils.assertArgNotNull((String)"pattern", (Object)pattern);
        Assertions.assertNotNull((Object)value, (String)"Value was null.");
        String v = BctConfiguration.getConverter().stringify(value);
        Matcher m = StringUtils.getGlobMatchPattern((String)pattern).matcher(v);
        Assertions.assertTrue((boolean)m.matches(), BctAssertions.composeMessage(message, "Pattern didn''t match. ==> pattern: <{0}> but was: <{1}>", pattern, v));
    }

    public static void assertNotEmpty(Object value) {
        BctAssertions.assertNotEmpty(null, value);
    }

    public static void assertNotEmpty(Supplier<String> message, Object value) {
        Assertions.assertNotNull((Object)value, (String)"Value was null.");
        int size = BctConfiguration.getConverter().size(value);
        Assertions.assertTrue((size > 0 ? 1 : 0) != 0, BctAssertions.composeMessage(message, "Value was empty.", new Object[0]));
    }

    public static void assertSize(int expected, Object actual) {
        BctAssertions.assertSize(null, expected, actual);
    }

    public static void assertSize(Supplier<String> message, int expected, Object actual) {
        Assertions.assertNotNull((Object)actual, (String)"Value was null.");
        int size = BctConfiguration.getConverter().size(actual);
        Assertions.assertEquals((int)expected, (int)size, BctAssertions.composeMessage(message, "Value not expected size.", new Object[0]));
    }

    public static void assertString(String expected, Object actual) {
        BctAssertions.assertString(null, expected, actual);
    }

    public static void assertString(Supplier<String> message, String expected, Object actual) {
        Assertions.assertNotNull((Object)actual, (String)"Value was null.");
        Supplier messageSupplier = message != null ? message : Utils.fs((String)"", (Object[])new Object[0]);
        Assertions.assertEquals((Object)expected, (Object)BctConfiguration.getConverter().stringify(actual), (Supplier)messageSupplier);
    }

    private static Supplier<String> composeMessage(Supplier<String> customMessage, String defaultMessage, Object ... defaultArgs) {
        if (customMessage == null) {
            return Utils.fs((String)defaultMessage, (Object[])defaultArgs);
        }
        return Utils.fs((String)"{0}, Caused by: {1}", (Object[])new Object[]{customMessage.get(), Utils.f((String)defaultMessage, (Object[])defaultArgs)});
    }

    private BctAssertions() {
    }
}

