/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.server.CounterSet;
import org.apache.jena.fuseki.servlets.ActionBase;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.ActionExecLib;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.query.QueryCancelledException;

public abstract class ActionService
extends ActionBase {
    @Override
    protected void executeLifecycle(HttpAction action) {
        CounterSet csService = action.getDataService() == null ? null : action.getDataService().getCounters();
        CounterSet csOperation = null;
        if (action.getEndpoint() != null) {
            csOperation = action.getEndpoint().getCounters();
        }
        ActionExecLib.incCounter(csService, CounterName.Requests);
        ActionExecLib.incCounter(csOperation, CounterName.Requests);
        try {
            this.validate(action);
        }
        catch (ActionErrorException ex) {
            ActionExecLib.incCounter(csOperation, CounterName.RequestsBad);
            ActionExecLib.incCounter(csService, CounterName.RequestsBad);
            throw ex;
        }
        try {
            this.execute(action);
            ActionExecLib.incCounter(csOperation, CounterName.RequestsGood);
            ActionExecLib.incCounter(csService, CounterName.RequestsGood);
        }
        catch (RuntimeIOException | ActionErrorException | QueryCancelledException ex) {
            ActionExecLib.incCounter(csOperation, CounterName.RequestsBad);
            ActionExecLib.incCounter(csService, CounterName.RequestsBad);
            throw ex;
        }
    }
}

