/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.List;
import java.util.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.shacl.engine.Parameter;
import org.apache.jena.shacl.lib.ShLib;

public class SparqlComponent {
    private final String sparqlString;
    private final List<Parameter> params;
    private final List<Node> requiredParameters;
    private final List<Node> optionalParameters;
    private final Node reportNode;
    private final String message;
    private final Query query;

    public static SparqlComponent constraintComponent(Node reportNode, String sparqlString, List<Parameter> params, String message) {
        return new SparqlComponent(sparqlString, params, reportNode, message);
    }

    public static SparqlComponent targetType(String sparqlString, List<Parameter> params) {
        return new SparqlComponent(sparqlString, params, null, null);
    }

    private SparqlComponent(String sparqlString, List<Parameter> params, Node reportNode, String message) {
        this.params = params;
        this.message = message;
        this.requiredParameters = params.stream().filter(param -> !param.isOptional()).map(param -> param.getParameterPath()).toList();
        this.optionalParameters = params.stream().filter(param -> param.isOptional()).map(param -> param.getParameterPath()).toList();
        this.reportNode = reportNode;
        this.sparqlString = sparqlString;
        this.query = ShLib.parseQueryString(sparqlString);
    }

    public Node getReportComponent() {
        return this.reportNode;
    }

    public Query getQuery() {
        return this.query;
    }

    public List<Parameter> getParams() {
        return this.params;
    }

    public String getMessage() {
        return this.message;
    }

    public List<Node> getRequiredParameters() {
        return this.requiredParameters;
    }

    public List<Node> getOptionalParameters() {
        return this.optionalParameters;
    }

    public String toString() {
        StringBuilder sbuff = new StringBuilder();
        if (this.query.isSelectType()) {
            sbuff.append("SELECT:");
        } else if (this.query.isAskType()) {
            sbuff.append("ASK:");
        } else {
            sbuff.append("???:");
        }
        sbuff.append(this.params.toString());
        return sbuff.toString();
    }

    public int hashCode() {
        return Objects.hash(this.message, this.optionalParameters, this.params, this.query, this.reportNode, this.requiredParameters, this.sparqlString);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SparqlComponent other = (SparqlComponent)obj;
        return Objects.equals(this.message, other.message) && Objects.equals(this.optionalParameters, other.optionalParameters) && Objects.equals(this.params, other.params) && Objects.equals(this.query, other.query) && Objects.equals(this.reportNode, other.reportNode) && Objects.equals(this.requiredParameters, other.requiredParameters) && Objects.equals(this.sparqlString, other.sparqlString);
    }
}

