/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import com.github.fge.lambdas.Throwing;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import java.net.InetSocketAddress;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imapserver.netty.NettyConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@ChannelHandler.Sharable
public class ImapIdleStateHandler
extends IdleStateHandler
implements NettyConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImapIdleStateHandler.class);

    public ImapIdleStateHandler(int allIdleTimeSeconds) {
        this(0, 0, allIdleTimeSeconds);
    }

    public ImapIdleStateHandler(int readerIdleTimeSeconds, int writerIdleTimeSeconds, int allIdleTimeSeconds) {
        super(readerIdleTimeSeconds, writerIdleTimeSeconds, allIdleTimeSeconds);
    }

    public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent e) throws Exception {
        if (e.state().equals((Object)IdleState.ALL_IDLE)) {
            ImapSession session = (ImapSession)ctx.channel().attr(IMAP_SESSION_ATTRIBUTE_KEY).get();
            InetSocketAddress address = (InetSocketAddress)ctx.channel().remoteAddress();
            LOGGER.info("Logout client {} ({}) because it idled for too long...", (Object)address.getHostName(), (Object)address.getAddress().getHostAddress());
            session.cancelOngoingProcessing();
            session.logout().then(Mono.fromRunnable(() -> ctx.channel().close())).then(Mono.fromRunnable((Runnable)Throwing.runnable(() -> super.channelIdle(ctx, e)))).subscribe(any -> {}, arg_0 -> ((ChannelHandlerContext)ctx).fireExceptionCaught(arg_0));
        } else {
            super.channelIdle(ctx, e);
        }
    }
}

