/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field.address;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.codec.DecoderUtil;
import org.apache.james.mime4j.dom.address.Address;
import org.apache.james.mime4j.dom.address.AddressList;
import org.apache.james.mime4j.dom.address.DomainList;
import org.apache.james.mime4j.dom.address.Group;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.dom.address.MailboxList;
import org.apache.james.mime4j.field.address.ASTaddr_spec;
import org.apache.james.mime4j.field.address.ASTaddress;
import org.apache.james.mime4j.field.address.ASTaddress_list;
import org.apache.james.mime4j.field.address.ASTangle_addr;
import org.apache.james.mime4j.field.address.ASTdomain;
import org.apache.james.mime4j.field.address.ASTgroup_body;
import org.apache.james.mime4j.field.address.ASTlocal_part;
import org.apache.james.mime4j.field.address.ASTmailbox;
import org.apache.james.mime4j.field.address.ASTname_addr;
import org.apache.james.mime4j.field.address.ASTphrase;
import org.apache.james.mime4j.field.address.ASTroute;
import org.apache.james.mime4j.field.address.Node;
import org.apache.james.mime4j.field.address.ParseException;
import org.apache.james.mime4j.field.address.SimpleNode;
import org.apache.james.mime4j.field.address.Token;

class Builder {
    private static final Builder singleton = new Builder();

    Builder() {
    }

    public static Builder getInstance() {
        return singleton;
    }

    public AddressList buildAddressList(ASTaddress_list node, DecodeMonitor monitor) throws ParseException {
        ArrayList<Address> list = new ArrayList<Address>();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            ASTaddress childNode = (ASTaddress)node.jjtGetChild(i);
            Address address = this.buildAddress(childNode, monitor);
            list.add(address);
        }
        return new AddressList(list, true);
    }

    public Address buildAddress(ASTaddress node, DecodeMonitor monitor) throws ParseException {
        ChildNodeIterator it = new ChildNodeIterator(node);
        Node n = it.next();
        if (n instanceof ASTaddr_spec) {
            return this.buildAddrSpec((ASTaddr_spec)n);
        }
        if (n instanceof ASTangle_addr) {
            return this.buildAngleAddr((ASTangle_addr)n);
        }
        if (n instanceof ASTphrase) {
            String name = this.buildString((ASTphrase)n, false);
            Node n2 = it.next();
            if (n2 instanceof ASTgroup_body) {
                return new Group(name, this.buildGroupBody((ASTgroup_body)n2, monitor));
            }
            if (n2 instanceof ASTangle_addr) {
                try {
                    name = DecoderUtil.decodeEncodedWords((String)name, (DecodeMonitor)monitor);
                }
                catch (IllegalArgumentException e) {
                    throw new ParseException(e);
                }
                Mailbox mb = this.buildAngleAddr((ASTangle_addr)n2);
                return new Mailbox(name, mb.getRoute(), mb.getLocalPart(), mb.getDomain());
            }
            throw new ParseException("Address \"group_body\" or \"angle_addr\" is expected but got \"" + n + "\"");
        }
        throw new ParseException("Address \"phrase\" is expected but got \"" + n + "\"");
    }

    private MailboxList buildGroupBody(ASTgroup_body node, DecodeMonitor monitor) throws ParseException {
        ArrayList<Mailbox> results = new ArrayList<Mailbox>();
        ChildNodeIterator it = new ChildNodeIterator(node);
        while (it.hasNext()) {
            Node n = it.next();
            if (n instanceof ASTmailbox) {
                results.add(this.buildMailbox((ASTmailbox)n, monitor));
                continue;
            }
            throw new ParseException("Address \"mailbox\" is expected but got \"" + n + "\"");
        }
        return new MailboxList(results, true);
    }

    public Mailbox buildMailbox(ASTmailbox node, DecodeMonitor monitor) throws ParseException {
        ChildNodeIterator it = new ChildNodeIterator(node);
        Node n = it.next();
        if (n instanceof ASTaddr_spec) {
            return this.buildAddrSpec((ASTaddr_spec)n);
        }
        if (n instanceof ASTangle_addr) {
            return this.buildAngleAddr((ASTangle_addr)n);
        }
        if (n instanceof ASTname_addr) {
            return this.buildNameAddr((ASTname_addr)n, monitor);
        }
        throw new ParseException("Address \"addr_spec\" or \"angle_addr\" or \"name_addr\" is expected but got \"" + n + "\"");
    }

    private Mailbox buildNameAddr(ASTname_addr node, DecodeMonitor monitor) throws ParseException {
        ChildNodeIterator it = new ChildNodeIterator(node);
        Node n = it.next();
        if (!(n instanceof ASTphrase)) {
            throw new ParseException("Address \"phrase\" is expected but got \"" + n + "\"");
        }
        String name = this.buildString((ASTphrase)n, false);
        n = it.next();
        if (n instanceof ASTangle_addr) {
            try {
                name = DecoderUtil.decodeEncodedWords((String)name, (DecodeMonitor)monitor);
            }
            catch (IllegalArgumentException e) {
                throw new ParseException(e);
            }
            Mailbox mb = this.buildAngleAddr((ASTangle_addr)n);
            return new Mailbox(name, mb.getRoute(), mb.getLocalPart(), mb.getDomain());
        }
        throw new ParseException("Address \"angle_addr\" is expected but got \"" + n + "\"");
    }

    private Mailbox buildAngleAddr(ASTangle_addr node) throws ParseException {
        ChildNodeIterator it = new ChildNodeIterator(node);
        DomainList route = null;
        Node n = it.next();
        if (n instanceof ASTroute) {
            route = this.buildRoute((ASTroute)n);
            n = it.next();
        } else if (!(n instanceof ASTaddr_spec)) {
            throw new ParseException("Address \"route\" or \"addr_spec\" is expected but got \"" + n + "\"");
        }
        if (n instanceof ASTaddr_spec) {
            return this.buildAddrSpec(route, (ASTaddr_spec)n);
        }
        throw new ParseException("Address \"addr_spec\" is expected but got \"" + n + "\"");
    }

    private DomainList buildRoute(ASTroute node) throws ParseException {
        ArrayList<String> results = new ArrayList<String>(node.jjtGetNumChildren());
        ChildNodeIterator it = new ChildNodeIterator(node);
        while (it.hasNext()) {
            Node n = it.next();
            if (n instanceof ASTdomain) {
                results.add(this.buildString((ASTdomain)n, true));
                continue;
            }
            throw new ParseException("Address \"domain\" is expected but got \"" + n + "\"");
        }
        return new DomainList(results);
    }

    private Mailbox buildAddrSpec(ASTaddr_spec node) {
        return this.buildAddrSpec(null, node);
    }

    private Mailbox buildAddrSpec(DomainList route, ASTaddr_spec node) {
        ChildNodeIterator it = new ChildNodeIterator(node);
        String localPart = this.buildString((ASTlocal_part)it.next(), true);
        String domain = this.buildString((ASTdomain)it.next(), true);
        return new Mailbox(route, localPart, domain);
    }

    private String buildString(SimpleNode node, boolean stripSpaces) {
        Token head = node.firstToken;
        Token tail = node.lastToken;
        StringBuilder out = new StringBuilder();
        while (head != tail) {
            out.append(head.image);
            head = head.next;
            if (stripSpaces) continue;
            this.addSpecials(out, head.specialToken);
        }
        out.append(tail.image);
        return out.toString();
    }

    private void addSpecials(StringBuilder out, Token specialToken) {
        if (specialToken != null) {
            this.addSpecials(out, specialToken.specialToken);
            out.append(specialToken.image);
        }
    }

    private static class ChildNodeIterator
    implements Iterator<Node> {
        private final SimpleNode simpleNode;
        private int index;
        private final int len;

        public ChildNodeIterator(SimpleNode simpleNode) {
            this.simpleNode = simpleNode;
            this.len = simpleNode.jjtGetNumChildren();
            this.index = 0;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.len;
        }

        @Override
        public Node next() {
            return this.simpleNode.jjtGetChild(this.index++);
        }
    }
}

