/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.mail;

import java.time.Duration;
import java.util.function.Function;
import org.apache.james.core.Username;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.acl.PositiveUserACLDiff;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.postgres.PostgresMailboxId;
import org.apache.james.mailbox.postgres.mail.PostgresACLUpsertException;
import org.apache.james.mailbox.postgres.mail.PostgresMailboxMapper;
import org.apache.james.mailbox.postgres.mail.PostgresMailboxMemberDAO;
import org.apache.james.mailbox.postgres.mail.dao.PostgresMailboxDAO;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

public class RLSSupportPostgresMailboxMapper
extends PostgresMailboxMapper {
    private final PostgresMailboxDAO postgresMailboxDAO;
    private final PostgresMailboxMemberDAO postgresMailboxMemberDAO;

    public RLSSupportPostgresMailboxMapper(PostgresMailboxDAO postgresMailboxDAO, PostgresMailboxMemberDAO postgresMailboxMemberDAO) {
        super(postgresMailboxDAO);
        this.postgresMailboxDAO = postgresMailboxDAO;
        this.postgresMailboxMemberDAO = postgresMailboxMemberDAO;
    }

    @Override
    public Flux<Mailbox> findNonPersonalMailboxes(Username userName, MailboxACL.Right right) {
        return this.postgresMailboxMemberDAO.findMailboxIdByUsername(userName).collectList().filter(postgresMailboxIds -> !postgresMailboxIds.isEmpty()).flatMapMany(this.postgresMailboxDAO::findMailboxByIds).filter(postgresMailbox -> ((MailboxACL.Rfc4314Rights)postgresMailbox.getACL().getEntries().get(MailboxACL.EntryKey.createUserEntryKey((Username)userName))).contains(right)).map(Function.identity());
    }

    @Override
    public Mono<ACLDiff> updateACL(Mailbox mailbox, MailboxACL.ACLCommand mailboxACLCommand) {
        return this.postgresMailboxDAO.getACL(mailbox.getMailboxId()).flatMap(pairMailboxACLAndVersion -> {
            try {
                MailboxACL newACL = ((MailboxACL)pairMailboxACLAndVersion.getLeft()).apply(mailboxACLCommand);
                return this.postgresMailboxDAO.upsertACL(mailbox.getMailboxId(), newACL, (Long)pairMailboxACLAndVersion.getRight()).thenReturn((Object)ACLDiff.computeDiff((MailboxACL)((MailboxACL)pairMailboxACLAndVersion.getLeft()), (MailboxACL)newACL));
            }
            catch (UnsupportedRightException e) {
                throw new RuntimeException(e);
            }
        }).retryWhen((Retry)Retry.backoff((long)3L, (Duration)Duration.ofMillis(100L)).filter(throwable -> throwable instanceof PostgresACLUpsertException)).flatMap(aclDiff -> this.updateMembersOfMailbox(mailbox, new PositiveUserACLDiff(aclDiff)).thenReturn(aclDiff));
    }

    @Override
    public Mono<ACLDiff> setACL(Mailbox mailbox, MailboxACL mailboxACL) {
        return this.postgresMailboxDAO.getACL(mailbox.getMailboxId()).flatMap(pairMailboxACLAndVersion -> this.postgresMailboxDAO.upsertACL(mailbox.getMailboxId(), mailboxACL, (Long)pairMailboxACLAndVersion.getRight()).thenReturn((Object)ACLDiff.computeDiff((MailboxACL)((MailboxACL)pairMailboxACLAndVersion.getLeft()), (MailboxACL)mailboxACL))).retryWhen((Retry)Retry.backoff((long)3L, (Duration)Duration.ofMillis(100L)).filter(throwable -> throwable instanceof PostgresACLUpsertException)).flatMap(aclDiff -> this.updateMembersOfMailbox(mailbox, new PositiveUserACLDiff(aclDiff)).thenReturn(aclDiff));
    }

    private Mono<Void> updateMembersOfMailbox(Mailbox mailbox, PositiveUserACLDiff userACLDiff) {
        return this.postgresMailboxMemberDAO.delete((PostgresMailboxId)PostgresMailboxId.class.cast(mailbox.getMailboxId()), userACLDiff.removedEntries().map(entry -> Username.of((String)((MailboxACL.EntryKey)entry.getKey()).getName())).toList()).then(this.postgresMailboxMemberDAO.insert((PostgresMailboxId)PostgresMailboxId.class.cast(mailbox.getMailboxId()), userACLDiff.addedEntries().map(entry -> Username.of((String)((MailboxACL.EntryKey)entry.getKey()).getName())).toList()));
    }
}

