/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.api;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public class OIDCSASLParser {
    public static final char SASL_SEPARATOR = '\u0001';
    public static final String PREFIX_TOKEN = "Bearer ";
    public static final String TOKEN_PART_PREFIX = "auth=";
    public static final String USER_PART_PREFIX = "user=";
    public static final int TOKEN_PART_INDEX = "auth=".length();
    public static final int USER_PART_INDEX = "user=".length();

    public static Optional<OIDCInitialResponse> parse(String initialResponse) {
        Optional<String> decodeResult = OIDCSASLParser.decodeBase64(initialResponse);
        if (decodeResult.isPresent()) {
            String decodeValueWithoutDanglingPart = decodeResult.filter(value -> value.startsWith("n,")).map(value -> value.substring(2)).orElse(decodeResult.get());
            StringTokenizer stringTokenizer = new StringTokenizer(decodeValueWithoutDanglingPart, String.valueOf('\u0001'));
            String tokenPart = null;
            String userPart = null;
            int tokenPartCounter = 0;
            int userPartCounter = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String stringToken = stringTokenizer.nextToken();
                if (stringToken.startsWith(TOKEN_PART_PREFIX)) {
                    tokenPart = StringUtils.replace((String)stringToken.substring(TOKEN_PART_INDEX), (String)PREFIX_TOKEN, (String)"");
                    ++tokenPartCounter;
                    continue;
                }
                if (!stringToken.startsWith(USER_PART_PREFIX)) continue;
                userPart = stringToken.substring(USER_PART_INDEX);
                ++userPartCounter;
            }
            if (tokenPart != null && userPart != null && tokenPartCounter == 1 && userPartCounter == 1) {
                return Optional.of(new OIDCInitialResponse(userPart, tokenPart));
            }
        }
        return Optional.empty();
    }

    private static Optional<String> decodeBase64(String line) {
        try {
            String lineWithoutTrailingCrLf = StringUtils.replace((String)line, (String)"\r\n", (String)"");
            return Optional.of(new String(Base64.getDecoder().decode(lineWithoutTrailingCrLf), StandardCharsets.US_ASCII));
        }
        catch (IllegalArgumentException exception) {
            return Optional.empty();
        }
    }

    public static class OIDCInitialResponse {
        private final String associatedUser;
        private final String token;

        public OIDCInitialResponse(String user, String token) {
            this.associatedUser = user;
            this.token = token;
        }

        public String getToken() {
            return this.token;
        }

        public String getAssociatedUser() {
            return this.associatedUser;
        }
    }
}

