/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth.internal.broker;

import com.google.common.base.Splitter;
import jakarta.annotation.Nonnull;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.polaris.immutables.PolarisImmutable;
import org.apache.polaris.service.auth.PolarisCredential;
import org.apache.polaris.service.auth.internal.broker.ImmutableInternalPolarisToken;
import org.immutables.value.Value;

@PolarisImmutable
abstract class InternalPolarisToken
implements PolarisCredential {
    private static final Splitter SCOPE_SPLITTER = Splitter.on((char)' ').omitEmptyStrings().trimResults();

    InternalPolarisToken() {
    }

    static InternalPolarisToken of(String principalName, Long principalId, String clientId, String scope) {
        return ImmutableInternalPolarisToken.builder().principalName(principalName).principalId(principalId).clientId(clientId).scope(scope).build();
    }

    @Override
    @Nonnull
    public abstract String getPrincipalName();

    @Override
    @Nonnull
    public abstract Long getPrincipalId();

    @Override
    @Value.Lazy
    public Set<String> getPrincipalRoles() {
        return SCOPE_SPLITTER.splitToStream((CharSequence)this.getScope()).collect(Collectors.toSet());
    }

    abstract String getClientId();

    abstract String getScope();
}

