/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.KmsResponse;
import software.amazon.awssdk.services.kms.model.MacAlgorithmSpec;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifyMacResponse
extends KmsResponse
implements ToCopyableBuilder<Builder, VerifyMacResponse> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(VerifyMacResponse.getter(VerifyMacResponse::keyId)).setter(VerifyMacResponse.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<Boolean> MAC_VALID_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MacValid").getter(VerifyMacResponse.getter(VerifyMacResponse::macValid)).setter(VerifyMacResponse.setter(Builder::macValid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacValid").build()}).build();
    private static final SdkField<String> MAC_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MacAlgorithm").getter(VerifyMacResponse.getter(VerifyMacResponse::macAlgorithmAsString)).setter(VerifyMacResponse.setter(Builder::macAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacAlgorithm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD, MAC_VALID_FIELD, MAC_ALGORITHM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VerifyMacResponse.memberNameToFieldInitializer();
    private final String keyId;
    private final Boolean macValid;
    private final String macAlgorithm;

    private VerifyMacResponse(BuilderImpl builder) {
        super(builder);
        this.keyId = builder.keyId;
        this.macValid = builder.macValid;
        this.macAlgorithm = builder.macAlgorithm;
    }

    public final String keyId() {
        return this.keyId;
    }

    public final Boolean macValid() {
        return this.macValid;
    }

    public final MacAlgorithmSpec macAlgorithm() {
        return MacAlgorithmSpec.fromValue(this.macAlgorithm);
    }

    public final String macAlgorithmAsString() {
        return this.macAlgorithm;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.macValid());
        hashCode = 31 * hashCode + Objects.hashCode(this.macAlgorithmAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyMacResponse)) {
            return false;
        }
        VerifyMacResponse other = (VerifyMacResponse)((Object)obj);
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.macValid(), other.macValid()) && Objects.equals(this.macAlgorithmAsString(), other.macAlgorithmAsString());
    }

    public final String toString() {
        return ToString.builder((String)"VerifyMacResponse").add("KeyId", (Object)this.keyId()).add("MacValid", (Object)this.macValid()).add("MacAlgorithm", (Object)this.macAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "MacValid": {
                return Optional.ofNullable(clazz.cast(this.macValid()));
            }
            case "MacAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.macAlgorithmAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KeyId", KEY_ID_FIELD);
        map.put("MacValid", MAC_VALID_FIELD);
        map.put("MacAlgorithm", MAC_ALGORITHM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerifyMacResponse, T> g) {
        return obj -> g.apply((VerifyMacResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsResponse.BuilderImpl
    implements Builder {
        private String keyId;
        private Boolean macValid;
        private String macAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyMacResponse model) {
            super(model);
            this.keyId(model.keyId);
            this.macValid(model.macValid);
            this.macAlgorithm(model.macAlgorithm);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final Boolean getMacValid() {
            return this.macValid;
        }

        public final void setMacValid(Boolean macValid) {
            this.macValid = macValid;
        }

        @Override
        public final Builder macValid(Boolean macValid) {
            this.macValid = macValid;
            return this;
        }

        public final String getMacAlgorithm() {
            return this.macAlgorithm;
        }

        public final void setMacAlgorithm(String macAlgorithm) {
            this.macAlgorithm = macAlgorithm;
        }

        @Override
        public final Builder macAlgorithm(String macAlgorithm) {
            this.macAlgorithm = macAlgorithm;
            return this;
        }

        @Override
        public final Builder macAlgorithm(MacAlgorithmSpec macAlgorithm) {
            this.macAlgorithm(macAlgorithm == null ? null : macAlgorithm.toString());
            return this;
        }

        @Override
        public VerifyMacResponse build() {
            return new VerifyMacResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, VerifyMacResponse> {
        public Builder keyId(String var1);

        public Builder macValid(Boolean var1);

        public Builder macAlgorithm(String var1);

        public Builder macAlgorithm(MacAlgorithmSpec var1);
    }
}

