/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.snapshot;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.management.api.ArgumentGroup;
import org.apache.ignite.internal.management.api.Positional;
import org.apache.ignite.internal.util.typedef.internal.U;

@ArgumentGroup(value={"start", "status", "cancel"}, onlyOneOf=true, optional=true)
public class SnapshotRestoreCommandArg
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    @Positional
    @Argument(description="Snapshot name. In the case of incremental snapshot (--incremental) full snapshot name must be provided")
    private String snapshotName;
    @Argument(optional=true, example="incrementIndex", description="Incremental snapshot index. The command will restore snapshot and after that all its increments sequentially from 1 to the specified index")
    private int increment;
    @Argument(optional=true, description="Cache group names", example="group1,...groupN")
    private String[] groups;
    @Argument(example="path", optional=true, description="Path to the directory where the snapshot files are located. If not specified, the default configured snapshot directory will be used")
    private String src;
    @Argument(optional=true, description="Run the operation synchronously, the command will wait for the entire operation to complete. Otherwise, it will be performed in the background, and the command will immediately return control")
    private boolean sync;
    @Argument(optional=true, description="Check snapshot data integrity before restore (slow!). Similar to the \"check\" command")
    private boolean check;
    @Argument(description="Snapshot restore operation status (Command deprecated. Use '--snapshot status' instead)")
    private boolean status;
    @Argument(description="Cancel snapshot restore operation (Command deprecated. Use '--snapshot cancel' instead)")
    private boolean cancel;
    @Argument(description="Start snapshot restore operation (Default action)")
    private boolean start;

    public void ensureOptions() {
        if (!this.sync) {
            return;
        }
        if (this.cancel) {
            throw new IllegalArgumentException("--sync and --cancel can't be used together");
        }
        if (this.status) {
            throw new IllegalArgumentException("--sync and --status can't be used together");
        }
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.snapshotName);
        out.writeInt(this.increment);
        U.writeArray(out, this.groups);
        U.writeString(out, this.src);
        out.writeBoolean(this.sync);
        out.writeBoolean(this.check);
        out.writeBoolean(this.status);
        out.writeBoolean(this.cancel);
        out.writeBoolean(this.start);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.snapshotName = U.readString(in);
        this.increment = in.readInt();
        this.groups = U.readArray(in, String.class);
        this.src = U.readString(in);
        this.sync = in.readBoolean();
        this.check = in.readBoolean();
        this.status = in.readBoolean();
        this.cancel = in.readBoolean();
        this.start = in.readBoolean();
    }

    public boolean start() {
        return this.start;
    }

    public void start(boolean start) {
        this.start = start;
        this.ensureOptions();
    }

    public boolean status() {
        return this.status;
    }

    public void status(boolean status) {
        this.status = status;
        this.ensureOptions();
    }

    public boolean cancel() {
        return this.cancel;
    }

    public void cancel(boolean cancel) {
        this.cancel = cancel;
        this.ensureOptions();
    }

    public String[] groups() {
        return this.groups;
    }

    public void groups(String[] groups) {
        this.groups = groups;
    }

    public String snapshotName() {
        return this.snapshotName;
    }

    public void snapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
    }

    public int increment() {
        return this.increment;
    }

    public void increment(int increment) {
        this.increment = increment;
    }

    public String src() {
        return this.src;
    }

    public void src(String src) {
        this.src = src;
    }

    public boolean sync() {
        return this.sync;
    }

    public void sync(boolean sync) {
        this.sync = sync;
        this.ensureOptions();
    }

    public boolean check() {
        return this.check;
    }

    public void check(boolean check) {
        this.check = check;
    }
}

