/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.management.api.Positional;
import org.apache.ignite.internal.util.typedef.internal.U;

public class CacheContentionCommandArg
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    @Positional
    @Argument(example="minQueueSize")
    private int minQueueSize;
    @Positional
    @Argument(optional=true, example="nodeId")
    private UUID nodeId;
    @Positional
    @Argument(optional=true, example="maxPrint")
    private int maxPrint = 10;

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeInt(this.minQueueSize);
        U.writeUuid(out, this.nodeId);
        out.writeInt(this.maxPrint);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.minQueueSize = in.readInt();
        this.nodeId = U.readUuid(in);
        this.maxPrint = in.readInt();
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public void nodeId(UUID nodeId) {
        this.nodeId = nodeId;
    }

    public int minQueueSize() {
        return this.minQueueSize;
    }

    public void minQueueSize(int minQueueSize) {
        this.minQueueSize = minQueueSize;
    }

    public int maxPrint() {
        return this.maxPrint;
    }

    public void maxPrint(int maxPrint) {
        this.maxPrint = maxPrint;
    }
}

