/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.sql.fun;

import java.util.Iterator;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.SameOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.validate.implicit.TypeCoercion;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.sql.engine.util.TypeUtils;

public class SameFamilyOperandTypeChecker
extends SameOperandTypeChecker {
    SameFamilyOperandTypeChecker(int countOfOperands) {
        super(countOfOperands);
    }

    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        boolean result;
        if (callBinding.isTypeCoercionEnabled()) {
            TypeCoercion typeCoercion = callBinding.getValidator().getTypeCoercion();
            typeCoercion.binaryComparisonCoercion(callBinding);
        }
        if (!(result = this.doCheckOperandTypes((SqlOperatorBinding)callBinding)) && throwOnFailure) {
            throw callBinding.newValidationSignatureError();
        }
        return result;
    }

    public SqlOperandTypeChecker.Consistency getConsistency() {
        return SqlOperandTypeChecker.Consistency.NONE;
    }

    private boolean doCheckOperandTypes(SqlOperatorBinding operatorBinding) {
        int actualCountOfOperands = this.nOperands;
        if (actualCountOfOperands == -1) {
            actualCountOfOperands = operatorBinding.getOperandCount();
        }
        RelDataType[] types = new RelDataType[actualCountOfOperands];
        List operandList = this.getOperandList(operatorBinding.getOperandCount());
        Iterator iterator = operandList.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            types[i] = operatorBinding.getOperandType(i);
        }
        int prev = -1;
        Iterator iterator2 = operandList.iterator();
        while (iterator2.hasNext()) {
            int i = (Integer)iterator2.next();
            if (prev >= 0 && !TypeUtils.typeFamiliesAreCompatible((RelDataTypeFactory)Commons.typeFactory(), types[i], types[prev])) {
                return false;
            }
            prev = i;
        }
        return true;
    }
}

