/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.command;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.ignite3.internal.metastorage.command.GetPrefixCommand;
import org.apache.ignite3.internal.metastorage.command.GetPrefixCommandBuilder;
import org.apache.ignite3.internal.metastorage.command.GetPrefixCommandSerializer;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class GetPrefixCommandImpl
implements GetPrefixCommand,
Cloneable {
    public static final short GROUP_TYPE = 111;
    public static final short TYPE = 61;
    @IgniteToStringInclude
    private final int batchSize;
    @IgniteToStringInclude
    private final boolean includeTombstones;
    @IgniteToStringInclude
    private final ByteBuffer prefix;
    @IgniteToStringInclude
    private final byte[] previousKey;
    @IgniteToStringInclude
    private final long revUpperBound;

    private GetPrefixCommandImpl(int batchSize, boolean includeTombstones, ByteBuffer prefix, byte[] previousKey, long revUpperBound) {
        this.batchSize = batchSize;
        this.includeTombstones = includeTombstones;
        this.prefix = prefix;
        this.previousKey = previousKey;
        this.revUpperBound = revUpperBound;
    }

    @Override
    public int batchSize() {
        return this.batchSize;
    }

    @Override
    public boolean includeTombstones() {
        return this.includeTombstones;
    }

    @Override
    public ByteBuffer prefix() {
        return this.prefix;
    }

    @Override
    public byte[] previousKey() {
        return this.previousKey;
    }

    @Override
    public long revUpperBound() {
        return this.revUpperBound;
    }

    public MessageSerializer serializer() {
        return GetPrefixCommandSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 111;
    }

    public String toString() {
        return S.toString(GetPrefixCommandImpl.class, this);
    }

    @Override
    public short messageType() {
        return 61;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GetPrefixCommandImpl otherMessage = (GetPrefixCommandImpl)other;
        return Objects.equals(this.prefix, otherMessage.prefix) && Arrays.equals(this.previousKey, otherMessage.previousKey) && this.batchSize == otherMessage.batchSize && this.includeTombstones == otherMessage.includeTombstones && this.revUpperBound == otherMessage.revUpperBound;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.batchSize, this.includeTombstones, this.revUpperBound, this.prefix);
        result = 31 * result + Arrays.hashCode(this.previousKey);
        return result;
    }

    @Override
    public GetPrefixCommandImpl clone() {
        try {
            return (GetPrefixCommandImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static GetPrefixCommandBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements GetPrefixCommandBuilder {
        private int batchSize;
        private boolean includeTombstones;
        private ByteBuffer prefix;
        private byte[] previousKey;
        private long revUpperBound;

        private Builder() {
        }

        @Override
        public GetPrefixCommandBuilder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        @Override
        public GetPrefixCommandBuilder includeTombstones(boolean includeTombstones) {
            this.includeTombstones = includeTombstones;
            return this;
        }

        @Override
        public GetPrefixCommandBuilder prefix(ByteBuffer prefix) {
            Objects.requireNonNull(prefix, "prefix is not marked @Nullable");
            this.prefix = prefix;
            return this;
        }

        @Override
        public GetPrefixCommandBuilder previousKey(byte[] previousKey) {
            this.previousKey = previousKey;
            return this;
        }

        @Override
        public GetPrefixCommandBuilder revUpperBound(long revUpperBound) {
            this.revUpperBound = revUpperBound;
            return this;
        }

        @Override
        public int batchSize() {
            return this.batchSize;
        }

        @Override
        public boolean includeTombstones() {
            return this.includeTombstones;
        }

        @Override
        public ByteBuffer prefix() {
            return this.prefix;
        }

        @Override
        public byte[] previousKey() {
            return this.previousKey;
        }

        @Override
        public long revUpperBound() {
            return this.revUpperBound;
        }

        @Override
        public GetPrefixCommand build() {
            return new GetPrefixCommandImpl(this.batchSize, this.includeTombstones, Objects.requireNonNull(this.prefix, "prefix is not marked @Nullable"), this.previousKey, this.revUpperBound);
        }
    }
}

