/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage;

import java.util.Collection;
import java.util.List;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.metastorage.EntryEvent;
import org.apache.ignite.internal.metastorage.timebag.TimeBag;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.TestOnly;

public class WatchEvent {
    @IgniteToStringInclude
    private final List<EntryEvent> entryEvts;
    private final long revision;
    private final HybridTimestamp timestamp;
    private final TimeBag timeBag;

    public WatchEvent(Collection<EntryEvent> entryEvts, long revision, HybridTimestamp timestamp, TimeBag timeBag) {
        this.entryEvts = List.copyOf(entryEvts);
        this.revision = revision;
        this.timestamp = timestamp;
        this.timeBag = timeBag;
    }

    @TestOnly
    public WatchEvent(EntryEvent entryEvt) {
        this(List.of(entryEvt), entryEvt.newEntry().revision(), HybridTimestamp.MAX_VALUE, TimeBag.createTimeBag(false, false));
    }

    public boolean single() {
        return this.entryEvts.size() == 1;
    }

    public Collection<EntryEvent> entryEvents() {
        return this.entryEvts;
    }

    public EntryEvent entryEvent() {
        assert (this.single()) : this.entryEvts;
        return this.entryEvts.get(0);
    }

    public long revision() {
        return this.revision;
    }

    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    public TimeBag timeBag() {
        return this.timeBag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatchEvent event = (WatchEvent)o;
        if (this.revision != event.revision) {
            return false;
        }
        return this.entryEvts.equals(event.entryEvts);
    }

    public int hashCode() {
        int result = this.entryEvts.hashCode();
        result = 31 * result + (int)(this.revision ^ this.revision >>> 32);
        return result;
    }

    public String toString() {
        return S.toString((Object)this);
    }
}

