/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.environment;

import java.io.Serializable;
import java.net.URI;
import java.time.Duration;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DescribedEnum;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.TextElement;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.storage.FileSystemCheckpointStorage;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.environment.ExecutionCheckpointingOptions;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Public
public class CheckpointConfig
implements Serializable {
    private static final long serialVersionUID = -750378776078908147L;
    private static final Logger LOG = LoggerFactory.getLogger(CheckpointConfig.class);
    @Deprecated
    public static final CheckpointingMode DEFAULT_MODE = (CheckpointingMode)((Object)ExecutionCheckpointingOptions.CHECKPOINTING_MODE.defaultValue());
    @Deprecated
    public static final long DEFAULT_TIMEOUT = ((Duration)ExecutionCheckpointingOptions.CHECKPOINTING_TIMEOUT.defaultValue()).toMillis();
    @Deprecated
    public static final long DEFAULT_MIN_PAUSE_BETWEEN_CHECKPOINTS = ((Duration)ExecutionCheckpointingOptions.MIN_PAUSE_BETWEEN_CHECKPOINTS.defaultValue()).toMillis();
    @Deprecated
    public static final int DEFAULT_MAX_CONCURRENT_CHECKPOINTS = (Integer)ExecutionCheckpointingOptions.MAX_CONCURRENT_CHECKPOINTS.defaultValue();
    @Deprecated
    public static final int UNDEFINED_TOLERABLE_CHECKPOINT_NUMBER = -1;
    @Deprecated
    public static final int DEFAULT_CHECKPOINT_ID_OF_IGNORED_IN_FLIGHT_DATA = ((Long)ExecutionCheckpointingOptions.CHECKPOINT_ID_OF_IGNORED_IN_FLIGHT_DATA.defaultValue()).intValue();
    private final Configuration configuration;
    @Deprecated
    private transient CheckpointStorage storage;

    public CheckpointConfig(CheckpointConfig checkpointConfig) {
        Preconditions.checkNotNull((Object)checkpointConfig);
        this.configuration = new Configuration(checkpointConfig.configuration);
        this.storage = checkpointConfig.getCheckpointStorage();
    }

    public CheckpointConfig() {
        this.configuration = new Configuration();
    }

    @Internal
    public CheckpointConfig(Configuration configuration) {
        this.configuration = configuration;
    }

    public void disableCheckpointing() {
        this.configuration.removeConfig(ExecutionCheckpointingOptions.CHECKPOINTING_INTERVAL);
    }

    public boolean isCheckpointingEnabled() {
        return this.getCheckpointInterval() > 0L;
    }

    public CheckpointingMode getCheckpointingMode() {
        return (CheckpointingMode)((Object)this.configuration.get(ExecutionCheckpointingOptions.CHECKPOINTING_MODE));
    }

    public void setCheckpointingMode(CheckpointingMode checkpointingMode) {
        this.configuration.set(ExecutionCheckpointingOptions.CHECKPOINTING_MODE, (Object)checkpointingMode);
    }

    public long getCheckpointInterval() {
        return this.configuration.getOptional(ExecutionCheckpointingOptions.CHECKPOINTING_INTERVAL).map(Duration::toMillis).orElse(-1L);
    }

    public void setCheckpointInterval(long checkpointInterval) {
        if (checkpointInterval < 10L) {
            throw new IllegalArgumentException(String.format("Checkpoint interval must be larger than or equal to %s ms", 10L));
        }
        this.configuration.set(ExecutionCheckpointingOptions.CHECKPOINTING_INTERVAL, (Object)Duration.ofMillis(checkpointInterval));
    }

    public long getCheckpointIntervalDuringBacklog() {
        long checkpointInterval;
        long intervalDuringBacklog = this.configuration.getOptional(ExecutionCheckpointingOptions.CHECKPOINTING_INTERVAL_DURING_BACKLOG).map(Duration::toMillis).orElseGet(this::getCheckpointInterval);
        if (intervalDuringBacklog < 10L) {
            intervalDuringBacklog = Long.MAX_VALUE;
        }
        if ((checkpointInterval = this.getCheckpointInterval()) < 10L) {
            checkpointInterval = Long.MAX_VALUE;
        }
        if (intervalDuringBacklog < checkpointInterval) {
            throw new IllegalArgumentException("Checkpoint interval during backlog must be larger than or equal to that in normal situation.");
        }
        return intervalDuringBacklog;
    }

    public void setCheckpointIntervalDuringBacklog(long checkpointInterval) {
        if (checkpointInterval != 0L && checkpointInterval < 10L) {
            throw new IllegalArgumentException(String.format("Checkpoint interval must be zero or larger than or equal to %s ms", 10L));
        }
        this.configuration.set(ExecutionCheckpointingOptions.CHECKPOINTING_INTERVAL_DURING_BACKLOG, (Object)Duration.ofMillis(checkpointInterval));
    }

    public long getCheckpointTimeout() {
        return ((Duration)this.configuration.get(ExecutionCheckpointingOptions.CHECKPOINTING_TIMEOUT)).toMillis();
    }

    public void setCheckpointTimeout(long checkpointTimeout) {
        if (checkpointTimeout < 10L) {
            throw new IllegalArgumentException(String.format("Checkpoint timeout must be larger than or equal to %s ms", 10L));
        }
        this.configuration.set(ExecutionCheckpointingOptions.CHECKPOINTING_TIMEOUT, (Object)Duration.ofMillis(checkpointTimeout));
    }

    public long getMinPauseBetweenCheckpoints() {
        return ((Duration)this.configuration.get(ExecutionCheckpointingOptions.MIN_PAUSE_BETWEEN_CHECKPOINTS)).toMillis();
    }

    public void setMinPauseBetweenCheckpoints(long minPauseBetweenCheckpoints) {
        if (minPauseBetweenCheckpoints < 0L) {
            throw new IllegalArgumentException("Pause value must be zero or positive");
        }
        this.configuration.set(ExecutionCheckpointingOptions.MIN_PAUSE_BETWEEN_CHECKPOINTS, (Object)Duration.ofMillis(minPauseBetweenCheckpoints));
    }

    public int getMaxConcurrentCheckpoints() {
        return (Integer)this.configuration.get(ExecutionCheckpointingOptions.MAX_CONCURRENT_CHECKPOINTS);
    }

    public void setMaxConcurrentCheckpoints(int maxConcurrentCheckpoints) {
        if (maxConcurrentCheckpoints < 1) {
            throw new IllegalArgumentException("The maximum number of concurrent attempts must be at least one.");
        }
        this.configuration.set(ExecutionCheckpointingOptions.MAX_CONCURRENT_CHECKPOINTS, (Object)maxConcurrentCheckpoints);
    }

    @Deprecated
    @PublicEvolving
    public boolean isForceCheckpointing() {
        return (Boolean)this.configuration.get(ExecutionCheckpointingOptions.FORCE_CHECKPOINTING);
    }

    @Deprecated
    @PublicEvolving
    public void setForceCheckpointing(boolean forceCheckpointing) {
        this.configuration.set(ExecutionCheckpointingOptions.FORCE_CHECKPOINTING, (Object)forceCheckpointing);
    }

    @PublicEvolving
    public boolean isForceUnalignedCheckpoints() {
        return (Boolean)this.configuration.get(ExecutionCheckpointingOptions.FORCE_UNALIGNED);
    }

    @PublicEvolving
    public void setForceUnalignedCheckpoints(boolean forceUnalignedCheckpoints) {
        this.configuration.set(ExecutionCheckpointingOptions.FORCE_UNALIGNED, (Object)forceUnalignedCheckpoints);
    }

    @Deprecated
    public boolean isFailOnCheckpointingErrors() {
        return this.getTolerableCheckpointFailureNumber() == 0;
    }

    @Deprecated
    public void setFailOnCheckpointingErrors(boolean failOnCheckpointingErrors) {
        if (this.configuration.getOptional(ExecutionCheckpointingOptions.TOLERABLE_FAILURE_NUMBER).isPresent()) {
            LOG.warn("Since ExecutionCheckpointingOptions.TOLERABLE_FAILURE_NUMBER has been configured as {}, deprecated #setFailOnCheckpointingErrors(boolean) method would not take any effect and please use #setTolerableCheckpointFailureNumber(int) method to determine your expected behaviour when checkpoint errors on task side.", (Object)this.getTolerableCheckpointFailureNumber());
            return;
        }
        if (failOnCheckpointingErrors) {
            this.setTolerableCheckpointFailureNumber(0);
        } else {
            this.setTolerableCheckpointFailureNumber(Integer.MAX_VALUE);
        }
    }

    public int getTolerableCheckpointFailureNumber() {
        return (Integer)this.configuration.get(ExecutionCheckpointingOptions.TOLERABLE_FAILURE_NUMBER);
    }

    public void setTolerableCheckpointFailureNumber(int tolerableCheckpointFailureNumber) {
        if (tolerableCheckpointFailureNumber < 0) {
            throw new IllegalArgumentException("The tolerable failure checkpoint number must be non-negative.");
        }
        this.configuration.set(ExecutionCheckpointingOptions.TOLERABLE_FAILURE_NUMBER, (Object)tolerableCheckpointFailureNumber);
    }

    @PublicEvolving
    public void setExternalizedCheckpointCleanup(ExternalizedCheckpointCleanup cleanupMode) {
        this.configuration.set(ExecutionCheckpointingOptions.EXTERNALIZED_CHECKPOINT, (Object)cleanupMode);
    }

    @Deprecated
    @PublicEvolving
    public void enableExternalizedCheckpoints(ExternalizedCheckpointCleanup cleanupMode) {
        this.setExternalizedCheckpointCleanup(cleanupMode);
    }

    @PublicEvolving
    public boolean isExternalizedCheckpointsEnabled() {
        return this.getExternalizedCheckpointCleanup() != ExternalizedCheckpointCleanup.NO_EXTERNALIZED_CHECKPOINTS;
    }

    @PublicEvolving
    public void enableUnalignedCheckpoints(boolean enabled) {
        this.configuration.set(ExecutionCheckpointingOptions.ENABLE_UNALIGNED, (Object)enabled);
    }

    @PublicEvolving
    public void enableUnalignedCheckpoints() {
        this.enableUnalignedCheckpoints(true);
    }

    @PublicEvolving
    public boolean isUnalignedCheckpointsEnabled() {
        return (Boolean)this.configuration.get(ExecutionCheckpointingOptions.ENABLE_UNALIGNED);
    }

    @Deprecated
    @PublicEvolving
    public void setAlignmentTimeout(Duration alignmentTimeout) {
        this.setAlignedCheckpointTimeout(alignmentTimeout);
    }

    @Deprecated
    @PublicEvolving
    public Duration getAlignmentTimeout() {
        return this.getAlignedCheckpointTimeout();
    }

    @PublicEvolving
    public Duration getAlignedCheckpointTimeout() {
        return (Duration)this.configuration.get(ExecutionCheckpointingOptions.ALIGNED_CHECKPOINT_TIMEOUT);
    }

    @PublicEvolving
    public void setAlignedCheckpointTimeout(Duration alignedCheckpointTimeout) {
        this.configuration.set(ExecutionCheckpointingOptions.ALIGNED_CHECKPOINT_TIMEOUT, (Object)alignedCheckpointTimeout);
    }

    @PublicEvolving
    public int getMaxSubtasksPerChannelStateFile() {
        return (Integer)this.configuration.get(ExecutionCheckpointingOptions.UNALIGNED_MAX_SUBTASKS_PER_CHANNEL_STATE_FILE);
    }

    @PublicEvolving
    public void setMaxSubtasksPerChannelStateFile(int maxSubtasksPerChannelStateFile) {
        this.configuration.set(ExecutionCheckpointingOptions.UNALIGNED_MAX_SUBTASKS_PER_CHANNEL_STATE_FILE, (Object)maxSubtasksPerChannelStateFile);
    }

    @Experimental
    public boolean isApproximateLocalRecoveryEnabled() {
        return (Boolean)this.configuration.get(ExecutionCheckpointingOptions.APPROXIMATE_LOCAL_RECOVERY);
    }

    @Experimental
    public void enableApproximateLocalRecovery(boolean enabled) {
        this.configuration.set(ExecutionCheckpointingOptions.APPROXIMATE_LOCAL_RECOVERY, (Object)enabled);
    }

    @PublicEvolving
    public ExternalizedCheckpointCleanup getExternalizedCheckpointCleanup() {
        return (ExternalizedCheckpointCleanup)((Object)this.configuration.get(ExecutionCheckpointingOptions.EXTERNALIZED_CHECKPOINT));
    }

    @Deprecated
    @PublicEvolving
    public void setCheckpointStorage(CheckpointStorage storage) {
        Preconditions.checkNotNull((Object)storage, (String)"Checkpoint storage must not be null");
        this.storage = storage;
    }

    @Deprecated
    @PublicEvolving
    public void setCheckpointStorage(String checkpointDirectory) {
        Preconditions.checkNotNull((Object)checkpointDirectory, (String)"Checkpoint directory must not be null");
        this.configuration.set(CheckpointingOptions.CHECKPOINTS_DIRECTORY, (Object)checkpointDirectory);
        this.storage = new FileSystemCheckpointStorage(checkpointDirectory);
    }

    @Deprecated
    @PublicEvolving
    public void setCheckpointStorage(URI checkpointDirectory) {
        Preconditions.checkNotNull((Object)checkpointDirectory, (String)"Checkpoint directory must not be null");
        this.configuration.set(CheckpointingOptions.CHECKPOINTS_DIRECTORY, (Object)checkpointDirectory.toString());
        this.storage = new FileSystemCheckpointStorage(checkpointDirectory);
    }

    @Deprecated
    @PublicEvolving
    public void setCheckpointStorage(Path checkpointDirectory) {
        Preconditions.checkNotNull((Object)checkpointDirectory, (String)"Checkpoint directory must not be null");
        this.configuration.set(CheckpointingOptions.CHECKPOINTS_DIRECTORY, (Object)checkpointDirectory.toString());
        this.storage = new FileSystemCheckpointStorage(checkpointDirectory);
    }

    @Deprecated
    @Nullable
    @PublicEvolving
    public CheckpointStorage getCheckpointStorage() {
        return this.storage;
    }

    @PublicEvolving
    public void setCheckpointIdOfIgnoredInFlightData(long checkpointIdOfIgnoredInFlightData) {
        this.configuration.set(ExecutionCheckpointingOptions.CHECKPOINT_ID_OF_IGNORED_IN_FLIGHT_DATA, (Object)checkpointIdOfIgnoredInFlightData);
    }

    @PublicEvolving
    public long getCheckpointIdOfIgnoredInFlightData() {
        return (Long)this.configuration.get(ExecutionCheckpointingOptions.CHECKPOINT_ID_OF_IGNORED_IN_FLIGHT_DATA);
    }

    public void configure(ReadableConfig configuration) {
        configuration.getOptional(ExecutionCheckpointingOptions.CHECKPOINTING_MODE).ifPresent(this::setCheckpointingMode);
        configuration.getOptional(ExecutionCheckpointingOptions.CHECKPOINTING_INTERVAL).ifPresent(i -> this.setCheckpointInterval(i.toMillis()));
        configuration.getOptional(ExecutionCheckpointingOptions.CHECKPOINTING_INTERVAL_DURING_BACKLOG).ifPresent(i -> this.setCheckpointIntervalDuringBacklog(i.toMillis()));
        configuration.getOptional(ExecutionCheckpointingOptions.CHECKPOINTING_TIMEOUT).ifPresent(t -> this.setCheckpointTimeout(t.toMillis()));
        configuration.getOptional(ExecutionCheckpointingOptions.MAX_CONCURRENT_CHECKPOINTS).ifPresent(this::setMaxConcurrentCheckpoints);
        configuration.getOptional(ExecutionCheckpointingOptions.MIN_PAUSE_BETWEEN_CHECKPOINTS).ifPresent(m -> this.setMinPauseBetweenCheckpoints(m.toMillis()));
        configuration.getOptional(ExecutionCheckpointingOptions.TOLERABLE_FAILURE_NUMBER).ifPresent(this::setTolerableCheckpointFailureNumber);
        configuration.getOptional(ExecutionCheckpointingOptions.EXTERNALIZED_CHECKPOINT).ifPresent(this::setExternalizedCheckpointCleanup);
        configuration.getOptional(ExecutionCheckpointingOptions.ENABLE_UNALIGNED).ifPresent(this::enableUnalignedCheckpoints);
        configuration.getOptional(ExecutionCheckpointingOptions.CHECKPOINT_ID_OF_IGNORED_IN_FLIGHT_DATA).ifPresent(this::setCheckpointIdOfIgnoredInFlightData);
        configuration.getOptional(ExecutionCheckpointingOptions.ALIGNED_CHECKPOINT_TIMEOUT).ifPresent(this::setAlignedCheckpointTimeout);
        configuration.getOptional(ExecutionCheckpointingOptions.UNALIGNED_MAX_SUBTASKS_PER_CHANNEL_STATE_FILE).ifPresent(this::setMaxSubtasksPerChannelStateFile);
        configuration.getOptional(ExecutionCheckpointingOptions.FORCE_UNALIGNED).ifPresent(this::setForceUnalignedCheckpoints);
        configuration.getOptional(CheckpointingOptions.CHECKPOINTS_DIRECTORY).ifPresent(this::setCheckpointStorage);
        configuration.getOptional(CheckpointingOptions.CHECKPOINT_STORAGE).ifPresent(ignored -> {
            this.storage = null;
        });
    }

    @Internal
    public Configuration toConfiguration() {
        return new Configuration(this.configuration);
    }

    @PublicEvolving
    public static enum ExternalizedCheckpointCleanup implements DescribedEnum
    {
        DELETE_ON_CANCELLATION((InlineElement)TextElement.text((String)"Checkpoint state is only kept when the owning job fails. It is deleted if the job is cancelled.")),
        RETAIN_ON_CANCELLATION((InlineElement)TextElement.text((String)"Checkpoint state is kept when the owning job is cancelled or fails.")),
        NO_EXTERNALIZED_CHECKPOINTS((InlineElement)TextElement.text((String)"Externalized checkpoints are disabled."));

        private final InlineElement description;

        private ExternalizedCheckpointCleanup(InlineElement description) {
            this.description = description;
        }

        public boolean deleteOnCancellation() {
            return this == DELETE_ON_CANCELLATION;
        }

        @Internal
        public InlineElement getDescription() {
            return this.description;
        }
    }
}

