/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.auto.value.AutoValue;
import com.google.cloud.spanner.BatchReadOnlyTransaction;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import java.util.Objects;
import org.apache.beam.runners.core.metrics.ServiceCallMetric;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_NaiveSpannerRead;
import org.apache.beam.sdk.io.gcp.spanner.ReadOperation;
import org.apache.beam.sdk.io.gcp.spanner.SpannerAccessor;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerIO;
import org.apache.beam.sdk.io.gcp.spanner.Transaction;
import org.apache.beam.sdk.metrics.Lineage;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
@AutoValue
abstract class NaiveSpannerRead
extends PTransform<PCollection<ReadOperation>, PCollection<Struct>> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(NaiveSpannerRead.class);

    NaiveSpannerRead() {
    }

    public static @UnknownKeyFor @NonNull @Initialized NaiveSpannerRead create(@UnknownKeyFor @NonNull @Initialized SpannerConfig spannerConfig, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Transaction> txView, @UnknownKeyFor @NonNull @Initialized TimestampBound timestampBound) {
        return new AutoValue_NaiveSpannerRead(spannerConfig, txView, timestampBound);
    }

    abstract @UnknownKeyFor @NonNull @Initialized SpannerConfig getSpannerConfig();

    abstract @Nullable @UnknownKeyFor @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Transaction> getTxView();

    abstract @UnknownKeyFor @NonNull @Initialized TimestampBound getTimestampBound();

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Struct> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ReadOperation> input) {
        PCollectionView txView = this.getTxView();
        if (txView == null) {
            Pipeline begin = input.getPipeline();
            SpannerIO.CreateTransaction createTx = SpannerIO.createTransaction().withSpannerConfig(this.getSpannerConfig()).withTimestampBound(this.getTimestampBound());
            txView = (PCollectionView)begin.apply((PTransform)createTx);
        }
        return (PCollection)input.apply("Naive read from Cloud Spanner", (PTransform)ParDo.of((DoFn)new NaiveSpannerReadFn(this.getSpannerConfig(), txView)).withSideInputs(new PCollectionView[]{txView}));
    }

    private static class NaiveSpannerReadFn
    extends DoFn<ReadOperation, Struct> {
        private final @UnknownKeyFor @NonNull @Initialized SpannerConfig config;
        private final @Nullable @UnknownKeyFor @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Transaction> txView;
        private transient @UnknownKeyFor @NonNull @Initialized SpannerAccessor spannerAccessor;
        private transient @UnknownKeyFor @NonNull @Initialized String projectId;
        private transient @Nullable @UnknownKeyFor @Initialized String reportedLineage;

        NaiveSpannerReadFn(@UnknownKeyFor @NonNull @Initialized SpannerConfig config, @Nullable @UnknownKeyFor @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Transaction> transaction) {
            this.config = config;
            this.txView = transaction;
        }

        @DoFn.Setup
        public void setup() throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.spannerAccessor = SpannerAccessor.getOrCreate(this.config);
            this.projectId = SpannerIO.resolveSpannerProjectId(this.config);
        }

        @DoFn.Teardown
        public void teardown() throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.spannerAccessor.close();
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
            Transaction tx = (Transaction)c.sideInput(this.txView);
            ReadOperation op = (ReadOperation)c.element();
            ServiceCallMetric serviceCallMetric = SpannerIO.ReadAll.buildServiceCallMetricForReadOp(this.config, op);
            BatchReadOnlyTransaction context = this.spannerAccessor.getBatchClient().batchReadOnlyTransaction(tx.transactionId());
            try (ResultSet resultSet = this.execute(op, context);){
                while (resultSet.next()) {
                    c.output((Object)resultSet.getCurrentRowAsStruct());
                }
            }
            catch (SpannerException e) {
                serviceCallMetric.call(e.getErrorCode().getGrpcStatusCode().toString());
                LOG.error("Error while reading operation: " + op, (Throwable)e);
                throw e;
            }
            serviceCallMetric.call("ok");
            @Nullable String tableName = op.tryGetTableName();
            if (!Objects.equals(this.reportedLineage, tableName)) {
                ImmutableList.Builder segments = ImmutableList.builder().add((Object[])new String[]{this.projectId, this.spannerAccessor.getInstanceConfigId(), (String)this.config.getInstanceId().get(), (String)this.config.getDatabaseId().get()});
                if (tableName != null) {
                    segments.add((Object)tableName);
                }
                Lineage.getSources().add("spanner", (Iterable)segments.build());
                this.reportedLineage = tableName;
            }
        }

        private @UnknownKeyFor @NonNull @Initialized ResultSet execute(@UnknownKeyFor @NonNull @Initialized ReadOperation op, @UnknownKeyFor @NonNull @Initialized BatchReadOnlyTransaction readOnlyTransaction) {
            Options.RpcPriority rpcPriority = SpannerConfig.DEFAULT_RPC_PRIORITY;
            if (this.config.getRpcPriority() != null && this.config.getRpcPriority().get() != null) {
                rpcPriority = (Options.RpcPriority)this.config.getRpcPriority().get();
            }
            if (op.getQuery() != null) {
                return readOnlyTransaction.executeQuery(op.getQuery(), new Options.QueryOption[]{Options.priority((Options.RpcPriority)rpcPriority)});
            }
            if (op.getIndex() != null) {
                return readOnlyTransaction.readUsingIndex(op.getTable(), op.getIndex(), op.getKeySet(), op.getColumns(), new Options.ReadOption[]{Options.priority((Options.RpcPriority)rpcPriority)});
            }
            return readOnlyTransaction.read(op.getTable(), op.getKeySet(), op.getColumns(), new Options.ReadOption[]{Options.priority((Options.RpcPriority)rpcPriority)});
        }
    }
}

